package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.Notification;

/**
 * Generated when a NETCONF server detects that aconfirmed-commit event has 
 * occurred. Indicates the eventand the current state of the confirmed-commit 
 * procedurein progress.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>ietf-netconf-notifications</b>
 * <pre>
 * notification netconf-confirmed-commit {
 *     description
 *         "Generated when a NETCONF server detects that a
 *         confirmed-commit event has occurred.  Indicates the event
 *         and the current state of the confirmed-commit procedure
 *         in progress.";
 *     leaf username {
 *         type string;
 *     }
 *     leaf session-id {
 *         type session-id-or-zero-type;
 *     }
 *     leaf source-host {
 *         type ip-address;
 *     }
 *     leaf confirm-event {
 *         type enumeration;
 *     }
 *     leaf timeout {
 *         type timeout;
 *     }
 *     uses common-session-parms;
 *     reference
 *         "RFC 6241, Section 8.4";
 * }
 * </pre>The schema path to identify an instance is
 * <i>ietf-netconf-notifications/netconf-confirmed-commit</i>
 *
 * <p>To create instances of this class use {@link NetconfConfirmedCommitBuilder}.
 * @see NetconfConfirmedCommitBuilder
 *
 */
public interface NetconfConfirmedCommit
    extends
    DataObject,
    Augmentable<org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.NetconfConfirmedCommit>,
    CommonSessionParms,
    Notification
{


    public enum ConfirmEvent {
        /**
         * The confirmed-commit procedure has started.
         *
         */
        Start(0, "start"),
        
        /**
         * The confirmed-commit procedure has been canceled,e.g., due to the session being 
         * terminated, or anexplicit &amp;lt;cancel-commit&amp;gt; operation.
         *
         */
        Cancel(1, "cancel"),
        
        /**
         * The confirmed-commit procedure has been canceleddue to the confirm-timeout 
         * interval expiring.The common session parameters will not be presentin this 
         * sub-mode.
         *
         */
        Timeout(2, "timeout"),
        
        /**
         * The confirmed-commit timeout has been extended,e.g., by a new 
         * &amp;lt;confirmed-commit&amp;gt; operation.
         *
         */
        Extend(3, "extend"),
        
        /**
         * The confirmed-commit procedure has been completed.
         *
         */
        Complete(4, "complete")
        ;
    
        private static final java.util.Map<java.lang.Integer, ConfirmEvent> VALUE_MAP;
    
        static {
            final com.google.common.collect.ImmutableMap.Builder<java.lang.Integer, ConfirmEvent> b = com.google.common.collect.ImmutableMap.builder();
            for (ConfirmEvent enumItem : ConfirmEvent.values()) {
                b.put(enumItem.value, enumItem);
            }
    
            VALUE_MAP = b.build();
        }
    
        private final java.lang.String name;
        private final int value;
    
        private ConfirmEvent(int value, java.lang.String name) {
            this.value = value;
            this.name = name;
        }
    
        /**
         * Returns the name of the enumeration item as it is specified in the input yang.
         *
         * @return the name of the enumeration item as it is specified in the input yang
         */
        public java.lang.String getName() {
            return name;
        }
    
        /**
         * @return integer value
         */
        public int getIntValue() {
            return value;
        }
    
        /**
         * @param valueArg integer value
         * @return corresponding ConfirmEvent item
         */
        public static ConfirmEvent forValue(int valueArg) {
            return VALUE_MAP.get(valueArg);
        }
    }

    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:ietf:params:xml:ns:yang:ietf-netconf-notifications",
        "2012-02-06", "netconf-confirmed-commit").intern();

    /**
     * Indicates the event that caused the notification.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.NetconfConfirmedCommit.ConfirmEvent</code> <code>confirmEvent</code>, or <code>null</code> if not present
     */
    ConfirmEvent getConfirmEvent();
    
    /**
     * The configured timeout value if the event typeis 'start' or 'extend'. This value
     * representsthe approximate number of seconds from the eventtime when the 
     * 'timeout' event might occur.
     *
     *
     *
     * @return <code>java.lang.Long</code> <code>timeout</code>, or <code>null</code> if not present
     */
    java.lang.Long getTimeout();

}

