package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.SessionIdType;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.Notification;

/**
 * Generated when a NETCONF server detects that aNETCONF session has terminated.A 
 * server MAY optionally generate this event fornon-NETCONF management sessions. 
 * Indicates theidentity of the user that owned the session,and why the session 
 * terminated.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>ietf-netconf-notifications</b>
 * <pre>
 * notification netconf-session-end {
 *     description
 *         "Generated when a NETCONF server detects that a
 *         NETCONF session has terminated.
 *         A server MAY optionally generate this event for
 *         non-NETCONF management sessions.  Indicates the
 *         identity of the user that owned the session,
 *         and why the session was terminated.";
 *     leaf username {
 *         type string;
 *     }
 *     leaf session-id {
 *         type session-id-or-zero-type;
 *     }
 *     leaf source-host {
 *         type ip-address;
 *     }
 *     leaf killed-by {
 *         type session-id-type;
 *     }
 *     leaf termination-reason {
 *         type enumeration;
 *     }
 *     uses common-session-parms;
 * }
 * </pre>The schema path to identify an instance is
 * <i>ietf-netconf-notifications/netconf-session-end</i>
 *
 * <p>To create instances of this class use {@link NetconfSessionEndBuilder}.
 * @see NetconfSessionEndBuilder
 *
 */
public interface NetconfSessionEnd
    extends
    DataObject,
    Augmentable<org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.NetconfSessionEnd>,
    CommonSessionParms,
    Notification
{


    public enum TerminationReason {
        /**
         * The session was terminated by the client in normalfashion, e.g., by the NETCONF 
         * &amp;lt;close-session&amp;gt;protocol operation.
         *
         */
        Closed(0, "closed"),
        
        /**
         * The session was terminated in abnormalfashion, e.g., by the NETCONF 
         * &amp;lt;kill-session&amp;gt;protocol operation.
         *
         */
        Killed(1, "killed"),
        
        /**
         * The session was terminated because the transport layerconnection was 
         * unexpectedly closed.
         *
         */
        Dropped(2, "dropped"),
        
        /**
         * The session was terminated because of inactivity,e.g., waiting for the 
         * &amp;lt;hello&amp;gt; message or &amp;lt;rpc&amp;gt;messages.
         *
         */
        Timeout(3, "timeout"),
        
        /**
         * The client's &amp;lt;hello&amp;gt; message was invalid.
         *
         */
        BadHello(4, "bad-hello"),
        
        /**
         * The session was terminated for some other reason.
         *
         */
        Other(5, "other")
        ;
    
        private static final java.util.Map<java.lang.Integer, TerminationReason> VALUE_MAP;
    
        static {
            final com.google.common.collect.ImmutableMap.Builder<java.lang.Integer, TerminationReason> b = com.google.common.collect.ImmutableMap.builder();
            for (TerminationReason enumItem : TerminationReason.values()) {
                b.put(enumItem.value, enumItem);
            }
    
            VALUE_MAP = b.build();
        }
    
        private final java.lang.String name;
        private final int value;
    
        private TerminationReason(int value, java.lang.String name) {
            this.value = value;
            this.name = name;
        }
    
        /**
         * Returns the name of the enumeration item as it is specified in the input yang.
         *
         * @return the name of the enumeration item as it is specified in the input yang
         */
        public java.lang.String getName() {
            return name;
        }
    
        /**
         * @return integer value
         */
        public int getIntValue() {
            return value;
        }
    
        /**
         * @param valueArg integer value
         * @return corresponding TerminationReason item
         */
        public static TerminationReason forValue(int valueArg) {
            return VALUE_MAP.get(valueArg);
        }
    }

    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:ietf:params:xml:ns:yang:ietf-netconf-notifications",
        "2012-02-06", "netconf-session-end").intern();

    /**
     * The ID of the session that directly caused this sessionto be abnormally 
     * terminated. If this session was abnormallyterminated by a non-NETCONF session 
     * unknown to the server,then this leaf will not be present.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.SessionIdType</code> <code>killedBy</code>, or <code>null</code> if not present
     */
    SessionIdType getKilledBy();
    
    /**
     * Reason the session was terminated.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.NetconfSessionEnd.TerminationReason</code> <code>terminationReason</code>, or <code>null</code> if not present
     */
    TerminationReason getTerminationReason();

}

