package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.Notification;

/**
 * Generated when a NETCONF server detects that aNETCONF session has started. A 
 * server MAY generatethis event for non-NETCONF management sessions.Indicates the 
 * identity of the user that startedthe session.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>ietf-netconf-notifications</b>
 * <pre>
 * notification netconf-session-start {
 *     description
 *         "Generated when a NETCONF server detects that a
 *         NETCONF session has started.  A server MAY generate
 *         this event for non-NETCONF management sessions.
 *         Indicates the identity of the user that started
 *         the session.";
 *     leaf username {
 *         type string;
 *     }
 *     leaf session-id {
 *         type session-id-or-zero-type;
 *     }
 *     leaf source-host {
 *         type ip-address;
 *     }
 *     uses common-session-parms;
 * }
 * </pre>The schema path to identify an instance is
 * <i>ietf-netconf-notifications/netconf-session-start</i>
 *
 * <p>To create instances of this class use {@link NetconfSessionStartBuilder}.
 * @see NetconfSessionStartBuilder
 *
 */
public interface NetconfSessionStart
    extends
    DataObject,
    Augmentable<org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.NetconfSessionStart>,
    CommonSessionParms,
    Notification
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:ietf:params:xml:ns:yang:ietf-netconf-notifications",
        "2012-02-06", "netconf-session-start").intern();


}

