package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.changed.by.parms;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.ChangedByParms;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.changed.by.parms.changed.by.ServerOrUser;
import org.opendaylight.yangtools.yang.binding.Augmentable;

/**
 * Indicates the source of the change.If caused by internal action, then theempty 
 * leaf 'server' will be present.If caused by a management session, thenthe name, 
 * remote host address, and session IDof the session that made the change will be 
 * reported.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>ietf-netconf-notifications</b>
 * <pre>
 * container changed-by {
 *     choice server-or-user {
 *         case by-user {
 *             leaf username {
 *                 type string;
 *             }
 *             leaf session-id {
 *                 type session-id-or-zero-type;
 *             }
 *             leaf source-host {
 *                 type ip-address;
 *             }
 *         }
 *         case server {
 *             leaf server {
 *                 type empty;
 *             }
 *         }
 *     }
 * }
 * </pre>The schema path to identify an instance is
 * <i>ietf-netconf-notifications/changed-by-parms/changed-by</i>
 *
 * <p>To create instances of this class use {@link ChangedByBuilder}.
 * @see ChangedByBuilder
 *
 */
public interface ChangedBy
    extends
    ChildOf<ChangedByParms>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.changed.by.parms.ChangedBy>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:ietf:params:xml:ns:yang:ietf-netconf-notifications",
        "2012-02-06", "changed-by").intern();

    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.changed.by.parms.changed.by.ServerOrUser</code> <code>serverOrUser</code>, or <code>null</code> if not present
     */
    ServerOrUser getServerOrUser();

}

