package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.netconf.config.change;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.NetconfConfigChange;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.EditOperationType;
import org.opendaylight.yangtools.yang.binding.Augmentable;

/**
 * An edit record SHOULD be present for each distinctedit operation that the 
 * has detected onthe target datastore. This list MAY be omittedif the detailed 
 * edit operations are not known.The server MAY report entries in this list 
 * forchanges not made by a NETCONF session (e.g., CLI).
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>ietf-netconf-notifications</b>
 * <pre>
 * list edit {
 *     leaf target {
 *         type instance-identifier;
 *     }
 *     leaf operation {
 *         type edit-operation-type;
 *     }
 * }
 * </pre>The schema path to identify an instance is
 * <i>ietf-netconf-notifications/netconf-config-change/edit</i>
 *
 * <p>To create instances of this class use {@link EditBuilder}.
 * @see EditBuilder
 *
 *
 */
public interface Edit
    extends
    ChildOf<NetconfConfigChange>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.netconf.config.change.Edit>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:ietf:params:xml:ns:yang:ietf-netconf-notifications",
        "2012-02-06", "edit").intern();

    /**
     * Topmost node associated with the configuration change.A server SHOULD set this 
     * object to the node withinthe datastore that is being altered. A server MAYset 
     * this object to one of the ancestors of the actualnode that was changed, or omit 
     * this object, if theexact node is not known.
     *
     *
     *
     * @return <code>org.opendaylight.yangtools.yang.binding.InstanceIdentifier</code> <code>target</code>, or <code>null</code> if not present
     */
    InstanceIdentifier<?> getTarget();
    
    /**
     * Type of edit operation performed.A server MUST set this object to the NETCONF 
     * editoperation performed on the target datastore.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.EditOperationType</code> <code>operation</code>, or <code>null</code> if not present
     */
    EditOperationType getOperation();

}

