/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.changed.by.parms.changed.by.server.or.user;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.changed.by.parms.changed.by.server.or.user.Server;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ServerBuilder
implements Builder<Server> {
    private Boolean _server;
    Map<Class<? extends Augmentation<Server>>, Augmentation<Server>> augmentation = Collections.emptyMap();

    public ServerBuilder() {
    }

    public ServerBuilder(Server base) {
        Map aug;
        this._server = base.isServer();
        if (base instanceof ServerImpl) {
            ServerImpl impl = (ServerImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Server>>, Augmentation<Server>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Server>>, Augmentation<Server>>(aug);
        }
    }

    public Boolean isServer() {
        return this._server;
    }

    public <E extends Augmentation<Server>> E augmentation(Class<E> augmentationType) {
        return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public ServerBuilder setServer(Boolean value) {
        this._server = value;
        return this;
    }

    public ServerBuilder addAugmentation(Class<? extends Augmentation<Server>> augmentationType, Augmentation<Server> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Server>>, Augmentation<Server>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public ServerBuilder removeAugmentation(Class<? extends Augmentation<Server>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Server build() {
        return new ServerImpl(this);
    }

    private static final class ServerImpl
    implements Server {
        private final Boolean _server;
        private Map<Class<? extends Augmentation<Server>>, Augmentation<Server>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        ServerImpl(ServerBuilder base) {
            this._server = base.isServer();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<Server> getImplementedInterface() {
            return Server.class;
        }

        @Override
        public Boolean isServer() {
            return this._server;
        }

        public <E extends Augmentation<Server>> E augmentation(Class<E> augmentationType) {
            return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._server);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Server.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Server other = (Server)obj;
            if (!Objects.equals(this._server, other.isServer())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ServerImpl otherImpl = (ServerImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Server>>, Augmentation<Server>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"Server");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_server", (Object)this._server);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

