package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.notification._1._0.rev080714;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.DateAndTime;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.RpcInput;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>notifications</b>
 * <pre>
 * input {
 *   leaf stream {
 *     type streamNameType;
 *     default NETCONF;
 *   }
 *   anyxml filter {
 *   }
 *   leaf startTime {
 *     type yang:date-and-time;
 *   }
 *   leaf stopTime {
 *     type yang:date-and-time;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>notifications/create-subscription/input</i>
 *
 * <p>To create instances of this class use {@link CreateSubscriptionInputBuilder}.
 * @see CreateSubscriptionInputBuilder
 *
 */
public interface CreateSubscriptionInput
    extends
    RpcInput,
    Augmentable<CreateSubscriptionInput>
{



    public static final QName QNAME = $YangModuleInfoImpl.qnameOf("input");

    /**
     * An optional parameter that indicates which stream of eventsis of interest. If 
     * not present, then events in the defaultNETCONF stream will be sent.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.notification._1._0.rev080714.StreamNameType</code> <code>stream</code>, or <code>null</code> if not present
     */
    @Nullable StreamNameType getStream();
    
    /**
     * A parameter used to trigger the replay feature andindicates that the replay 
     * should start at the timespecified. If start time is not present, this is not 
     * areplay subscription.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.DateAndTime</code> <code>startTime</code>, or <code>null</code> if not present
     */
    @Nullable DateAndTime getStartTime();
    
    /**
     * An optional parameter used with the optional replayfeature to indicate the 
     * newest notifications ofinterest. If stop time is not present, the 
     * notificationswill continue until the subscription is terminated.Must be used 
     * with startTime.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.DateAndTime</code> <code>stopTime</code>, or <code>null</code> if not present
     */
    @Nullable DateAndTime getStopTime();

}

