package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.notification._1._0.rev080714;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.DateAndTime;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link CreateSubscriptionInputBuilder} instances.
 *
 * @see CreateSubscriptionInputBuilder
 *
 */
public class CreateSubscriptionInputBuilder implements Builder<CreateSubscriptionInput> {

    private DateAndTime _startTime;
    private DateAndTime _stopTime;
    private StreamNameType _stream;


    Map<Class<? extends Augmentation<CreateSubscriptionInput>>, Augmentation<CreateSubscriptionInput>> augmentation = Collections.emptyMap();

    public CreateSubscriptionInputBuilder() {
    }

    public CreateSubscriptionInputBuilder(CreateSubscriptionInput base) {
        this._startTime = base.getStartTime();
        this._stopTime = base.getStopTime();
        this._stream = base.getStream();
        if (base instanceof CreateSubscriptionInputImpl) {
            CreateSubscriptionInputImpl impl = (CreateSubscriptionInputImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<CreateSubscriptionInput>>, Augmentation<CreateSubscriptionInput>> aug =((AugmentationHolder<CreateSubscriptionInput>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
    }


    public DateAndTime getStartTime() {
        return _startTime;
    }
    
    public DateAndTime getStopTime() {
        return _stopTime;
    }
    
    public StreamNameType getStream() {
        return _stream;
    }
    
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<CreateSubscriptionInput>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public CreateSubscriptionInputBuilder setStartTime(final DateAndTime value) {
        this._startTime = value;
        return this;
    }
    
    public CreateSubscriptionInputBuilder setStopTime(final DateAndTime value) {
        this._stopTime = value;
        return this;
    }
    
    public CreateSubscriptionInputBuilder setStream(final StreamNameType value) {
        this._stream = value;
        return this;
    }
    
    public CreateSubscriptionInputBuilder addAugmentation(Class<? extends Augmentation<CreateSubscriptionInput>> augmentationType, Augmentation<CreateSubscriptionInput> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public CreateSubscriptionInputBuilder removeAugmentation(Class<? extends Augmentation<CreateSubscriptionInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public CreateSubscriptionInput build() {
        return new CreateSubscriptionInputImpl(this);
    }

    private static final class CreateSubscriptionInputImpl implements CreateSubscriptionInput {
    
        private final DateAndTime _startTime;
        private final DateAndTime _stopTime;
        private final StreamNameType _stream;
    
        private Map<Class<? extends Augmentation<CreateSubscriptionInput>>, Augmentation<CreateSubscriptionInput>> augmentation = Collections.emptyMap();
    
        CreateSubscriptionInputImpl(CreateSubscriptionInputBuilder base) {
            this._startTime = base.getStartTime();
            this._stopTime = base.getStopTime();
            this._stream = base.getStream();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<CreateSubscriptionInput> getImplementedInterface() {
            return CreateSubscriptionInput.class;
        }
    
        @Override
        public DateAndTime getStartTime() {
            return _startTime;
        }
        
        @Override
        public DateAndTime getStopTime() {
            return _stopTime;
        }
        
        @Override
        public StreamNameType getStream() {
            return _stream;
        }
        
        @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
        @Override
        public <E$$ extends Augmentation<CreateSubscriptionInput>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_startTime);
            result = prime * result + Objects.hashCode(_stopTime);
            result = prime * result + Objects.hashCode(_stream);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!CreateSubscriptionInput.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            CreateSubscriptionInput other = (CreateSubscriptionInput)obj;
            if (!Objects.equals(_startTime, other.getStartTime())) {
                return false;
            }
            if (!Objects.equals(_stopTime, other.getStopTime())) {
                return false;
            }
            if (!Objects.equals(_stream, other.getStream())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                CreateSubscriptionInputImpl otherImpl = (CreateSubscriptionInputImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<CreateSubscriptionInput>>, Augmentation<CreateSubscriptionInput>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("CreateSubscriptionInput");
            CodeHelpers.appendValue(helper, "_startTime", _startTime);
            CodeHelpers.appendValue(helper, "_stopTime", _stopTime);
            CodeHelpers.appendValue(helper, "_stream", _stream);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
