package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.notification._1._0.rev080714;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link CreateSubscriptionOutputBuilder} instances.
 *
 * @see CreateSubscriptionOutputBuilder
 *
 */
public class CreateSubscriptionOutputBuilder implements Builder<CreateSubscriptionOutput> {



    Map<Class<? extends Augmentation<CreateSubscriptionOutput>>, Augmentation<CreateSubscriptionOutput>> augmentation = Collections.emptyMap();

    public CreateSubscriptionOutputBuilder() {
    }

    public CreateSubscriptionOutputBuilder(CreateSubscriptionOutput base) {
        if (base instanceof CreateSubscriptionOutputImpl) {
            CreateSubscriptionOutputImpl impl = (CreateSubscriptionOutputImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<CreateSubscriptionOutput>>, Augmentation<CreateSubscriptionOutput>> aug =((AugmentationHolder<CreateSubscriptionOutput>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
    }


    
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<CreateSubscriptionOutput>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public CreateSubscriptionOutputBuilder addAugmentation(Class<? extends Augmentation<CreateSubscriptionOutput>> augmentationType, Augmentation<CreateSubscriptionOutput> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public CreateSubscriptionOutputBuilder removeAugmentation(Class<? extends Augmentation<CreateSubscriptionOutput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public CreateSubscriptionOutput build() {
        return new CreateSubscriptionOutputImpl(this);
    }

    private static final class CreateSubscriptionOutputImpl implements CreateSubscriptionOutput {
    
    
        private Map<Class<? extends Augmentation<CreateSubscriptionOutput>>, Augmentation<CreateSubscriptionOutput>> augmentation = Collections.emptyMap();
    
        CreateSubscriptionOutputImpl(CreateSubscriptionOutputBuilder base) {
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<CreateSubscriptionOutput> getImplementedInterface() {
            return CreateSubscriptionOutput.class;
        }
    
        
        @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
        @Override
        public <E$$ extends Augmentation<CreateSubscriptionOutput>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!CreateSubscriptionOutput.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            CreateSubscriptionOutput other = (CreateSubscriptionOutput)obj;
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                CreateSubscriptionOutputImpl otherImpl = (CreateSubscriptionOutputImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<CreateSubscriptionOutput>>, Augmentation<CreateSubscriptionOutput>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("CreateSubscriptionOutput");
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
