package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.notification._1._0.rev080714;
import com.google.common.util.concurrent.ListenableFuture;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.common.RpcResult;

/**
 * Interface for implementing the following YANG RPCs defined in module <b>notifications</b>
 * <pre>
 * rpc create-subscription {
 *   input {
 *     leaf stream {
 *       type streamNameType;
 *       default NETCONF;
 *     }
 *     anyxml filter {
 *     }
 *     leaf startTime {
 *       type yang:date-and-time;
 *     }
 *     leaf stopTime {
 *       type yang:date-and-time;
 *     }
 *   }
 *   output;
 * }
 * </pre>
 *
 */
public interface NotificationsService
    extends
    RpcService
{




    /**
     * The command to create a notification subscription. Ittakes as argument the name 
     * of the notification streamand filter. Both of those options limit the content 
     * ofthe subscription. In addition, there are two time-relatedparameters, startTime
     * and stopTime, which can be used toselect the time interval of interest to the 
     * notificationreplay feature.
     *
     */
    ListenableFuture<RpcResult<CreateSubscriptionOutput>> createSubscription(CreateSubscriptionInput input);

}

