package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.DataRoot;

/**
 * Conversion of the 'manageEvent' XSD in the NETCONF Notifications RFC.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>nc-notifications</b>
 * <pre>
 * module nc-notifications {
 *   namespace urn:ietf:params:xml:ns:netmod:notification;
 *   prefix manageEvent;
 *   import ietf-yang-types {
 *     prefix yang;
 *     revision-date 2013-07-15;
 *   }
 *   import notifications {
 *     prefix ncEvent;
 *     revision-date 2008-07-14;
 *   }
 *   revision 2008-07-14 {
 *   }
 *   container netconf {
 *     config false;
 *     container streams {
 *       list stream {
 *         key name;
 *         min-elements 1;
 *         leaf name {
 *           type ncEvent:streamNameType;
 *         }
 *         leaf description {
 *           type string;
 *         }
 *         leaf replaySupport {
 *           type boolean;
 *         }
 *         leaf replayLogCreationTime {
 *           type yang:date-and-time;
 *         }
 *       }
 *     }
 *   }
 *   notification replayComplete {
 *   }
 *   notification notificationComplete {
 *   }
 * }
 * </pre>
 *
 */
public interface NcNotificationsData
    extends
    DataRoot
{




    /**
     * Top-level element in the notification namespace
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.Netconf</code> <code>netconf</code>, or <code>null</code> if not present
     */
    @Nullable Netconf getNetconf();

}

