package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * This notification is sent to signal the end of a notification subscription. It 
 * is sent in the case that stopTime was specified during the creation of the 
 * subscription..
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>nc-notifications</b>
 * <pre>
 * notification notificationComplete {
 * }
 * </pre>The schema path to identify an instance is
 * <i>nc-notifications/notificationComplete</i>
 *
 * <p>To create instances of this class use {@link NotificationCompleteBuilder}.
 * @see NotificationCompleteBuilder
 *
 */
public interface NotificationComplete
    extends
    DataObject,
    Augmentable<NotificationComplete>,
    Notification
{



    public static final QName QNAME = $YangModuleInfoImpl.qnameOf("notificationComplete");


}

