package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NotificationCompleteBuilder} instances.
 *
 * @see NotificationCompleteBuilder
 *
 */
public class NotificationCompleteBuilder implements Builder<NotificationComplete> {



    Map<Class<? extends Augmentation<NotificationComplete>>, Augmentation<NotificationComplete>> augmentation = Collections.emptyMap();

    public NotificationCompleteBuilder() {
    }

    public NotificationCompleteBuilder(NotificationComplete base) {
        if (base instanceof NotificationCompleteImpl) {
            NotificationCompleteImpl impl = (NotificationCompleteImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<NotificationComplete>>, Augmentation<NotificationComplete>> aug =((AugmentationHolder<NotificationComplete>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
    }


    
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<NotificationComplete>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public NotificationCompleteBuilder addAugmentation(Class<? extends Augmentation<NotificationComplete>> augmentationType, Augmentation<NotificationComplete> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public NotificationCompleteBuilder removeAugmentation(Class<? extends Augmentation<NotificationComplete>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NotificationComplete build() {
        return new NotificationCompleteImpl(this);
    }

    private static final class NotificationCompleteImpl implements NotificationComplete {
    
    
        private Map<Class<? extends Augmentation<NotificationComplete>>, Augmentation<NotificationComplete>> augmentation = Collections.emptyMap();
    
        NotificationCompleteImpl(NotificationCompleteBuilder base) {
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<NotificationComplete> getImplementedInterface() {
            return NotificationComplete.class;
        }
    
        
        @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
        @Override
        public <E$$ extends Augmentation<NotificationComplete>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NotificationComplete.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NotificationComplete other = (NotificationComplete)obj;
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NotificationCompleteImpl otherImpl = (NotificationCompleteImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NotificationComplete>>, Augmentation<NotificationComplete>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NotificationComplete");
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
