package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.netconf;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.Netconf;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.netconf.streams.Stream;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * The list of event streams supported by the system. When a query is issued, the 
 * returned set of streams is determined based on user privileges.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>nc-notifications</b>
 * <pre>
 * container streams {
 *   list stream {
 *     key name;
 *     min-elements 1;
 *     leaf name {
 *       type ncEvent:streamNameType;
 *     }
 *     leaf description {
 *       type string;
 *     }
 *     leaf replaySupport {
 *       type boolean;
 *     }
 *     leaf replayLogCreationTime {
 *       type yang:date-and-time;
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>nc-notifications/netconf/streams</i>
 *
 * <p>To create instances of this class use {@link StreamsBuilder}.
 * @see StreamsBuilder
 *
 */
public interface Streams
    extends
    ChildOf<Netconf>,
    Augmentable<Streams>
{



    public static final QName QNAME = $YangModuleInfoImpl.qnameOf("streams");

    /**
     * Stream name, description and other information.
     *
     *
     *
     * @return <code>java.util.List</code> <code>stream</code>, or <code>null</code> if not present
     */
    @Nullable List<Stream> getStream();
    
    /**
     * @return <code>java.util.List</code> <code>stream</code>, or an empty list if it is not present
     */
    default @NonNull List<Stream> nonnullStream() {
        return CodeHelpers.nonnull(getStream());
    }

}

