package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.changed.by.parms.ChangedBy;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Common parameters to identify the source of a change event, such as a 
 * configuration or capability change.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>ietf-netconf-notifications</b>
 * <pre>
 * grouping changed-by-parms {
 *   container changed-by {
 *     choice server-or-user {
 *       case server {
 *         leaf server {
 *           type empty;
 *         }
 *       }
 *       case by-user {
 *         uses common-session-parms;
 *       }
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>ietf-netconf-notifications/changed-by-parms</i>
 *
 */
public interface ChangedByParms
    extends
    DataObject
{



    public static final QName QNAME = $YangModuleInfoImpl.qnameOf("changed-by-parms");

    /**
     * Indicates the source of the change.If caused by internal action, then theempty 
     * leaf 'server' will be present.If caused by a management session, thenthe name, 
     * remote host address, and session IDof the session that made the change will be 
     * reported.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.changed.by.parms.ChangedBy</code> <code>changedBy</code>, or <code>null</code> if not present
     */
    @Nullable ChangedBy getChangedBy();

}

