package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206;
import org.opendaylight.yangtools.yang.binding.NotificationListener;

/**
 * Interface for implementing the following YANG notifications defined in module <b>ietf-netconf-notifications</b>
 * <pre>
 * notification netconf-confirmed-commit {
 *   uses common-session-parms {
 *     when "confirm-event != 'timeout'";
 *   }
 *   leaf confirm-event {
 *     type enumeration {
 *       enum start {
 *       }
 *       enum cancel {
 *       }
 *       enum timeout {
 *       }
 *       enum extend {
 *       }
 *       enum complete {
 *       }
 *     }
 *   }
 *   leaf timeout {
 *     when "../confirm-event = 'start' or ../confirm-event = 'extend'";
 *     type uint32;
 *     units seconds;
 *   }
 * }
 * notification netconf-session-start {
 *   uses common-session-parms;
 * }
 * notification netconf-session-end {
 *   uses common-session-parms;
 *   leaf killed-by {
 *     when "../termination-reason = 'killed'";
 *     type nc:session-id-type;
 *   }
 *   leaf termination-reason {
 *     type enumeration {
 *       enum closed {
 *       }
 *       enum killed {
 *       }
 *       enum dropped {
 *       }
 *       enum timeout {
 *       }
 *       enum bad-hello {
 *       }
 *       enum other {
 *       }
 *     }
 *   }
 * }
 * notification netconf-capability-change {
 *   uses changed-by-parms;
 *   leaf-list added-capability {
 *     type inet:uri;
 *   }
 *   leaf-list deleted-capability {
 *     type inet:uri;
 *   }
 *   leaf-list modified-capability {
 *     type inet:uri;
 *   }
 * }
 * notification netconf-config-change {
 *   uses changed-by-parms;
 *   leaf datastore {
 *     type enumeration {
 *       enum running {
 *       }
 *       enum startup {
 *       }
 *     }
 *     default running;
 *   }
 *   list edit {
 *     leaf target {
 *       type instance-identifier;
 *     }
 *     leaf operation {
 *       type nc:edit-operation-type;
 *     }
 *   }
 * }
 * </pre>
 *
 */
public interface IetfNetconfNotificationsListener
    extends
    NotificationListener
{




    /**
     * Generated when a NETCONF server detects that aconfirmed-commit event has 
     * occurred. Indicates the eventand the current state of the confirmed-commit 
     * procedurein progress.
     *
     */
    void onNetconfConfirmedCommit(NetconfConfirmedCommit notification);
    
    /**
     * Generated when a NETCONF server detects that aNETCONF session has started. A 
     * server MAY generatethis event for non-NETCONF management sessions.Indicates the 
     * identity of the user that startedthe session.
     *
     */
    void onNetconfSessionStart(NetconfSessionStart notification);
    
    /**
     * Generated when a NETCONF server detects that aNETCONF session has terminated.A 
     * server MAY optionally generate this event fornon-NETCONF management sessions. 
     * Indicates theidentity of the user that owned the session,and why the session was
     * terminated.
     *
     */
    void onNetconfSessionEnd(NetconfSessionEnd notification);
    
    /**
     * Generated when the NETCONF server detects thatthe server capabilities have 
     * changed.Indicates which capabilities have been added, deleted,and/or modified. 
     * The manner in which a servercapability is changed is outside the scope of 
     * thisdocument.
     *
     */
    void onNetconfCapabilityChange(NetconfCapabilityChange notification);
    
    /**
     * Generated when the NETCONF server detects that the&amp;lt;running&amp;gt; or 
     * &amp;lt;startup&amp;gt; configuration datastorehas been changed by a management 
     * session.The notification summarizes the edits thathave been detected.The server 
     * MAY choose to also generate thisnotification while loading a datastore during 
     * theboot process for the device.
     *
     */
    void onNetconfConfigChange(NetconfConfigChange notification);

}

