package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Uri;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Generated when the NETCONF server detects that the server capabilities have 
 * changed. Indicates which capabilities have been added, deleted, and/or 
 * The manner in which a server capability is changed is outside the scope of this 
 * document.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>ietf-netconf-notifications</b>
 * <pre>
 * notification netconf-capability-change {
 *   uses changed-by-parms;
 *   leaf-list added-capability {
 *     type inet:uri;
 *   }
 *   leaf-list deleted-capability {
 *     type inet:uri;
 *   }
 *   leaf-list modified-capability {
 *     type inet:uri;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>ietf-netconf-notifications/netconf-capability-change</i>
 *
 * <p>To create instances of this class use {@link NetconfCapabilityChangeBuilder}.
 * @see NetconfCapabilityChangeBuilder
 *
 */
public interface NetconfCapabilityChange
    extends
    DataObject,
    Augmentable<NetconfCapabilityChange>,
    ChangedByParms,
    Notification
{



    public static final QName QNAME = $YangModuleInfoImpl.qnameOf("netconf-capability-change");

    /**
     * List of capabilities that have just been added.
     *
     *
     *
     * @return <code>java.util.List</code> <code>addedCapability</code>, or <code>null</code> if not present
     */
    @Nullable List<Uri> getAddedCapability();
    
    /**
     * List of capabilities that have just been deleted.
     *
     *
     *
     * @return <code>java.util.List</code> <code>deletedCapability</code>, or <code>null</code> if not present
     */
    @Nullable List<Uri> getDeletedCapability();
    
    /**
     * List of capabilities that have just been modified.A capability is considered to 
     * be modified if thebase URI for the capability has not changed, butone or more of
     * the parameters encoded at the end ofthe capability URI have changed.The new 
     * modified value of the complete URI is returned.
     *
     *
     *
     * @return <code>java.util.List</code> <code>modifiedCapability</code>, or <code>null</code> if not present
     */
    @Nullable List<Uri> getModifiedCapability();

}

