package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMap.Builder;
import java.lang.Integer;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.netconf.config.change.Edit;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Enumeration;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Generated when the NETCONF server detects that the &lt;running&gt; or 
 * &lt;startup&gt; configuration datastore has been changed by a management 
 * session. The notification summarizes the edits that have been detected. The 
 * server MAY choose to also generate this notification while loading a datastore 
 * during the boot process for the device.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>ietf-netconf-notifications</b>
 * <pre>
 * notification netconf-config-change {
 *   uses changed-by-parms;
 *   leaf datastore {
 *     type enumeration {
 *       enum running {
 *       }
 *       enum startup {
 *       }
 *     }
 *     default running;
 *   }
 *   list edit {
 *     leaf target {
 *       type instance-identifier;
 *     }
 *     leaf operation {
 *       type nc:edit-operation-type;
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>ietf-netconf-notifications/netconf-config-change</i>
 *
 * <p>To create instances of this class use {@link NetconfConfigChangeBuilder}.
 * @see NetconfConfigChangeBuilder
 *
 */
public interface NetconfConfigChange
    extends
    DataObject,
    Augmentable<NetconfConfigChange>,
    ChangedByParms,
    Notification
{


    public enum Datastore implements Enumeration {
        /**
         * The &amp;lt;running&amp;gt; datastore has changed.
         *
         */
        Running(0, "running"),
        
        /**
         * The &amp;lt;startup&amp;gt; datastore has changed
         *
         */
        Startup(1, "startup")
        ;
    
        private static final Map<String, Datastore> NAME_MAP;
        private static final Map<Integer, Datastore> VALUE_MAP;
    
        static {
            final Builder<String, Datastore> nb = ImmutableMap.builder();
            final Builder<Integer, Datastore> vb = ImmutableMap.builder();
            for (Datastore enumItem : Datastore.values()) {
                vb.put(enumItem.value, enumItem);
                nb.put(enumItem.name, enumItem);
            }
    
            NAME_MAP = nb.build();
            VALUE_MAP = vb.build();
        }
    
        private final String name;
        private final int value;
    
        private Datastore(int value, String name) {
            this.value = value;
            this.name = name;
        }
    
        @Override
        public String getName() {
            return name;
        }
    
        @Override
        public int getIntValue() {
            return value;
        }
    
        /**
         * Return the enumeration member whose {@link #getName()} matches specified value.
         *
         * @param name YANG assigned name
         * @return corresponding Datastore item, if present
         * @throws NullPointerException if name is null
         */
        public static Optional<Datastore> forName(String name) {
            return Optional.ofNullable(NAME_MAP.get(Objects.requireNonNull(name)));
        }
    
        /**
         * Return the enumeration member whose {@link #getIntValue()} matches specified value.
         *
         * @param intValue integer value
         * @return corresponding Datastore item, or null if no such item exists
         */
        public static Datastore forValue(int intValue) {
            return VALUE_MAP.get(intValue);
        }
    }

    public static final QName QNAME = $YangModuleInfoImpl.qnameOf("netconf-config-change");

    /**
     * Indicates which configuration datastore has changed.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.NetconfConfigChange.Datastore</code> <code>datastore</code>, or <code>null</code> if not present
     */
    @Nullable Datastore getDatastore();
    
    /**
     * An edit record SHOULD be present for each distinctedit operation that the server
     * has detected onthe target datastore. This list MAY be omittedif the detailed 
     * edit operations are not known.The server MAY report entries in this list 
     * forchanges not made by a NETCONF session (e.g., CLI).
     *
     *
     *
     * @return <code>java.util.List</code> <code>edit</code>, or <code>null</code> if not present
     */
    @Nullable List<Edit> getEdit();
    
    /**
     * @return <code>java.util.List</code> <code>edit</code>, or an empty list if it is not present
     */
    default @NonNull List<Edit> nonnullEdit() {
        return CodeHelpers.nonnull(getEdit());
    }

}

