package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.changed.by.parms;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.changed.by.parms.changed.by.ServerOrUser;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link ChangedByBuilder} instances.
 *
 * @see ChangedByBuilder
 *
 */
public class ChangedByBuilder implements Builder<ChangedBy> {

    private ServerOrUser _serverOrUser;


    Map<Class<? extends Augmentation<ChangedBy>>, Augmentation<ChangedBy>> augmentation = Collections.emptyMap();

    public ChangedByBuilder() {
    }

    public ChangedByBuilder(ChangedBy base) {
        this._serverOrUser = base.getServerOrUser();
        if (base instanceof ChangedByImpl) {
            ChangedByImpl impl = (ChangedByImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<ChangedBy>>, Augmentation<ChangedBy>> aug =((AugmentationHolder<ChangedBy>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
    }


    public ServerOrUser getServerOrUser() {
        return _serverOrUser;
    }
    
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<ChangedBy>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public ChangedByBuilder setServerOrUser(final ServerOrUser value) {
        this._serverOrUser = value;
        return this;
    }
    
    public ChangedByBuilder addAugmentation(Class<? extends Augmentation<ChangedBy>> augmentationType, Augmentation<ChangedBy> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public ChangedByBuilder removeAugmentation(Class<? extends Augmentation<ChangedBy>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public ChangedBy build() {
        return new ChangedByImpl(this);
    }

    private static final class ChangedByImpl implements ChangedBy {
    
        private final ServerOrUser _serverOrUser;
    
        private Map<Class<? extends Augmentation<ChangedBy>>, Augmentation<ChangedBy>> augmentation = Collections.emptyMap();
    
        ChangedByImpl(ChangedByBuilder base) {
            this._serverOrUser = base.getServerOrUser();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<ChangedBy> getImplementedInterface() {
            return ChangedBy.class;
        }
    
        @Override
        public ServerOrUser getServerOrUser() {
            return _serverOrUser;
        }
        
        @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
        @Override
        public <E$$ extends Augmentation<ChangedBy>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_serverOrUser);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ChangedBy.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            ChangedBy other = (ChangedBy)obj;
            if (!Objects.equals(_serverOrUser, other.getServerOrUser())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                ChangedByImpl otherImpl = (ChangedByImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<ChangedBy>>, Augmentation<ChangedBy>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("ChangedBy");
            CodeHelpers.appendValue(helper, "_serverOrUser", _serverOrUser);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
