package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.netconf.config.change;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.EditOperationType;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.NetconfConfigChange;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * An edit record SHOULD be present for each distinct edit operation that the 
 * server has detected on the target datastore. This list MAY be omitted if the 
 * detailed edit operations are not known. The server MAY report entries in this 
 * list for changes not made by a NETCONF session (e.g., CLI).
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>ietf-netconf-notifications</b>
 * <pre>
 * list edit {
 *   leaf target {
 *     type instance-identifier;
 *   }
 *   leaf operation {
 *     type nc:edit-operation-type;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>ietf-netconf-notifications/netconf-config-change/edit</i>
 *
 * <p>To create instances of this class use {@link EditBuilder}.
 * @see EditBuilder
 *
 *
 */
public interface Edit
    extends
    ChildOf<NetconfConfigChange>,
    Augmentable<Edit>
{



    public static final QName QNAME = $YangModuleInfoImpl.qnameOf("edit");

    /**
     * Topmost node associated with the configuration change.A server SHOULD set this 
     * object to the node withinthe datastore that is being altered. A server MAYset 
     * this object to one of the ancestors of the actualnode that was changed, or omit 
     * this object, if theexact node is not known.
     *
     *
     *
     * @return <code>org.opendaylight.yangtools.yang.binding.InstanceIdentifier</code> <code>target</code>, or <code>null</code> if not present
     */
    @Nullable InstanceIdentifier<?> getTarget();
    
    /**
     * Type of edit operation performed.A server MUST set this object to the NETCONF 
     * editoperation performed on the target datastore.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.EditOperationType</code> <code>operation</code>, or <code>null</code> if not present
     */
    @Nullable EditOperationType getOperation();

}

