package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.netconf.config.change;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.EditOperationType;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;

/**
 * Class that builds {@link EditBuilder} instances.
 *
 * @see EditBuilder
 *
 */
public class EditBuilder implements Builder<Edit> {

    private EditOperationType _operation;
    private InstanceIdentifier<?> _target;


    Map<Class<? extends Augmentation<Edit>>, Augmentation<Edit>> augmentation = Collections.emptyMap();

    public EditBuilder() {
    }

    public EditBuilder(Edit base) {
        this._operation = base.getOperation();
        this._target = base.getTarget();
        if (base instanceof EditImpl) {
            EditImpl impl = (EditImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<Edit>>, Augmentation<Edit>> aug =((AugmentationHolder<Edit>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
    }


    public EditOperationType getOperation() {
        return _operation;
    }
    
    public InstanceIdentifier<?> getTarget() {
        return _target;
    }
    
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Edit>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public EditBuilder setOperation(final EditOperationType value) {
        this._operation = value;
        return this;
    }
    
    public EditBuilder setTarget(final InstanceIdentifier<?> value) {
        this._target = value;
        return this;
    }
    
    public EditBuilder addAugmentation(Class<? extends Augmentation<Edit>> augmentationType, Augmentation<Edit> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public EditBuilder removeAugmentation(Class<? extends Augmentation<Edit>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Edit build() {
        return new EditImpl(this);
    }

    private static final class EditImpl implements Edit {
    
        private final EditOperationType _operation;
        private final InstanceIdentifier<?> _target;
    
        private Map<Class<? extends Augmentation<Edit>>, Augmentation<Edit>> augmentation = Collections.emptyMap();
    
        EditImpl(EditBuilder base) {
            this._operation = base.getOperation();
            this._target = base.getTarget();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<Edit> getImplementedInterface() {
            return Edit.class;
        }
    
        @Override
        public EditOperationType getOperation() {
            return _operation;
        }
        
        @Override
        public InstanceIdentifier<?> getTarget() {
            return _target;
        }
        
        @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
        @Override
        public <E$$ extends Augmentation<Edit>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_operation);
            result = prime * result + Objects.hashCode(_target);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Edit.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Edit other = (Edit)obj;
            if (!Objects.equals(_operation, other.getOperation())) {
                return false;
            }
            if (!Objects.equals(_target, other.getTarget())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                EditImpl otherImpl = (EditImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<Edit>>, Augmentation<Edit>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("Edit");
            CodeHelpers.appendValue(helper, "_operation", _operation);
            CodeHelpers.appendValue(helper, "_target", _target);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
