package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.notification._1._0.rev080714;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.notification._1._0.rev080714.create.subscription.input.Filter;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.DateAndTime;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.RpcInput;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>notifications</b>
 * <pre>
 * input {
 *   leaf stream {
 *     type streamNameType;
 *     default NETCONF;
 *   }
 *   anyxml filter {
 *   }
 *   leaf startTime {
 *     type yang:date-and-time;
 *   }
 *   leaf stopTime {
 *     type yang:date-and-time;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>notifications/create-subscription/input</i>
 *
 * <p>To create instances of this class use {@link CreateSubscriptionInputBuilder}.
 * @see CreateSubscriptionInputBuilder
 *
 */
public interface CreateSubscriptionInput
    extends
    RpcInput,
    Augmentable<CreateSubscriptionInput>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("input");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.notification._1._0.rev080714.CreateSubscriptionInput> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.notification._1._0.rev080714.CreateSubscriptionInput.class;
    }
    
    /**
     * An optional parameter that indicates which stream of events is of interest. If 
     * not present, then events in the default NETCONF stream will be sent.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.notification._1._0.rev080714.StreamNameType</code> <code>stream</code>, or <code>null</code> if not present
     */
    @Nullable StreamNameType getStream();
    
    /**
     * An optional parameter that indicates which subset of all possible events is of 
     * interest. The format of this parameter is the same as that of the filter 
     * parameter in the NETCONF protocol operations. If not present, all events not 
     * precluded by other parameters will be sent.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.notification._1._0.rev080714.create.subscription.input.Filter</code> <code>filter</code>, or <code>null</code> if not present
     */
    @Nullable Filter getFilter();
    
    /**
     * A parameter used to trigger the replay feature and indicates that the replay 
     * should start at the time specified. If start time is not present, this is not a 
     * replay subscription.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.DateAndTime</code> <code>startTime</code>, or <code>null</code> if not present
     */
    @Nullable DateAndTime getStartTime();
    
    /**
     * An optional parameter used with the optional replay feature to indicate the 
     * newest notifications of interest. If stop time is not present, the notifications
     * will continue until the subscription is terminated. Must be used with startTime.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.DateAndTime</code> <code>stopTime</code>, or <code>null</code> if not present
     */
    @Nullable DateAndTime getStopTime();

}

