package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.notification._1._0.rev080714;
import com.google.common.util.concurrent.ListenableFuture;
import edu.umd.cs.findbugs.annotations.CheckReturnValue;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.common.RpcResult;

/**
 * Interface for implementing the following YANG RPCs defined in module <b>notifications</b>
 * <pre>
 * rpc create-subscription {
 *   input {
 *     leaf stream {
 *       type streamNameType;
 *       default NETCONF;
 *     }
 *     anyxml filter {
 *     }
 *     leaf startTime {
 *       type yang:date-and-time;
 *     }
 *     leaf stopTime {
 *       type yang:date-and-time;
 *     }
 *   }
 *   output;
 * }
 * </pre>
 *
 */
public interface NotificationsService
    extends
    RpcService
{




    /**
     * The command to create a notification subscription. It takes as argument the name
     * of the notification stream and filter. Both of those options limit the content 
     * of the subscription. In addition, there are two time-related parameters, 
     * startTime and stopTime, which can be used to select the time interval of 
     * interest to the notification replay feature.
     *
     */
    @CheckReturnValue
    ListenableFuture<RpcResult<CreateSubscriptionOutput>> createSubscription(CreateSubscriptionInput input);

}

