package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.netconf.Streams;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Top-level element in the notification namespace
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>nc-notifications</b>
 * <pre>
 * container netconf {
 *   config false;
 *   container streams {
 *     list stream {
 *       key name;
 *       min-elements 1;
 *       leaf name {
 *         type ncEvent:streamNameType;
 *       }
 *       leaf description {
 *         type string;
 *       }
 *       leaf replaySupport {
 *         type boolean;
 *       }
 *       leaf replayLogCreationTime {
 *         type yang:date-and-time;
 *       }
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>nc-notifications/netconf</i>
 *
 * <p>To create instances of this class use {@link NetconfBuilder}.
 * @see NetconfBuilder
 *
 */
public interface Netconf
    extends
    ChildOf<NcNotificationsData>,
    Augmentable<Netconf>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("netconf");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.Netconf> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.Netconf.class;
    }
    
    /**
     * The list of event streams supported by the system. When a query is issued, the 
     * returned set of streams is determined based on user privileges.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.netconf.Streams</code> <code>streams</code>, or <code>null</code> if not present
     */
    @Nullable Streams getStreams();

}

