package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.netconf.streams;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.notification._1._0.rev080714.StreamNameType;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.netconf.Streams;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.DateAndTime;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Stream name, description and other information.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>nc-notifications</b>
 * <pre>
 * list stream {
 *   key name;
 *   min-elements 1;
 *   leaf name {
 *     type ncEvent:streamNameType;
 *   }
 *   leaf description {
 *     type string;
 *   }
 *   leaf replaySupport {
 *     type boolean;
 *   }
 *   leaf replayLogCreationTime {
 *     type yang:date-and-time;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>nc-notifications/netconf/streams/stream</i>
 *
 * <p>To create instances of this class use {@link StreamBuilder}.
 * @see StreamBuilder
 * @see StreamKey
 *
 */
public interface Stream
    extends
    ChildOf<Streams>,
    Augmentable<Stream>,
    Identifiable<StreamKey>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("stream");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.netconf.streams.Stream> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.netconf.streams.Stream.class;
    }
    
    /**
     * The name of the event stream. If this is the default NETCONF stream, this must 
     * have the value 'NETCONF'.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.notification._1._0.rev080714.StreamNameType</code> <code>name</code>, or <code>null</code> if not present
     */
    @Nullable StreamNameType getName();
    
    /**
     * A description of the event stream, including such information as the type of 
     * events that are sent over this stream.
     *
     *
     *
     * @return <code>java.lang.String</code> <code>description</code>, or <code>null</code> if not present
     */
    @Nullable String getDescription();
    
    /**
     * A description of the event stream, including such information as the type of 
     * events that are sent over this stream.
     *
     *
     *
     * @return <code>java.lang.Boolean</code> <code>replaySupport</code>, or <code>null</code> if not present
     */
    @Nullable Boolean isReplaySupport();
    
    /**
     * The timestamp of the creation of the log used to support the replay function on 
     * this stream. Note that this might be earlier then the earliest available 
     * notification in the log. This object is updated if the log resets for some 
     * reason. This object MUST be present if replay is supported.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.DateAndTime</code> <code>replayLogCreationTime</code>, or <code>null</code> if not present
     */
    @Nullable DateAndTime getReplayLogCreationTime();
    
    @Override
    StreamKey key();

}

