package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.SessionIdOrZeroType;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Common session parameters to identify a management session.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>ietf-netconf-notifications</b>
 * <pre>
 * grouping common-session-parms {
 *   leaf username {
 *     type string;
 *   }
 *   leaf session-id {
 *     type nc:session-id-or-zero-type;
 *   }
 *   leaf source-host {
 *     type inet:ip-address;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>ietf-netconf-notifications/common-session-parms</i>
 *
 */
public interface CommonSessionParms
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("common-session-parms");

    @Override
    Class<? extends CommonSessionParms> implementedInterface();
    
    /**
     * Name of the user for the session.
     *
     *
     *
     * @return <code>java.lang.String</code> <code>username</code>, or <code>null</code> if not present
     */
    @Nullable String getUsername();
    
    /**
     * Identifier of the session. A NETCONF session MUST be identified by a non-zero 
     * value. A non-NETCONF session MAY be identified by the value zero.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.SessionIdOrZeroType</code> <code>sessionId</code>, or <code>null</code> if not present
     */
    @Nullable SessionIdOrZeroType getSessionId();
    
    /**
     * Address of the remote host for the session.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress</code> <code>sourceHost</code>, or <code>null</code> if not present
     */
    @Nullable IpAddress getSourceHost();

}

