package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Uri;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.changed.by.parms.ChangedBy;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NetconfCapabilityChangeBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     NetconfCapabilityChangeBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new NetconfCapabilityChangeBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of NetconfCapabilityChangeBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see NetconfCapabilityChangeBuilder
 * @see Builder
 *
 */
public class NetconfCapabilityChangeBuilder implements Builder<NetconfCapabilityChange> {

    private List<Uri> _addedCapability;
    private ChangedBy _changedBy;
    private List<Uri> _deletedCapability;
    private List<Uri> _modifiedCapability;


    Map<Class<? extends Augmentation<NetconfCapabilityChange>>, Augmentation<NetconfCapabilityChange>> augmentation = Collections.emptyMap();

    public NetconfCapabilityChangeBuilder() {
    }
    public NetconfCapabilityChangeBuilder(org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.ChangedByParms arg) {
        this._changedBy = arg.getChangedBy();
    }

    public NetconfCapabilityChangeBuilder(NetconfCapabilityChange base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<NetconfCapabilityChange>>, Augmentation<NetconfCapabilityChange>> aug =((AugmentationHolder<NetconfCapabilityChange>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._addedCapability = base.getAddedCapability();
        this._changedBy = base.getChangedBy();
        this._deletedCapability = base.getDeletedCapability();
        this._modifiedCapability = base.getModifiedCapability();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.ChangedByParms</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.ChangedByParms) {
            this._changedBy = ((org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.ChangedByParms)arg).getChangedBy();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.ChangedByParms]");
    }

    public List<Uri> getAddedCapability() {
        return _addedCapability;
    }
    
    public ChangedBy getChangedBy() {
        return _changedBy;
    }
    
    public List<Uri> getDeletedCapability() {
        return _deletedCapability;
    }
    
    public List<Uri> getModifiedCapability() {
        return _modifiedCapability;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<NetconfCapabilityChange>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    public NetconfCapabilityChangeBuilder setAddedCapability(final List<Uri> values) {
        this._addedCapability = values;
        return this;
    }
    
    
    public NetconfCapabilityChangeBuilder setChangedBy(final ChangedBy value) {
        this._changedBy = value;
        return this;
    }
    public NetconfCapabilityChangeBuilder setDeletedCapability(final List<Uri> values) {
        this._deletedCapability = values;
        return this;
    }
    
    public NetconfCapabilityChangeBuilder setModifiedCapability(final List<Uri> values) {
        this._modifiedCapability = values;
        return this;
    }
    
    
    public NetconfCapabilityChangeBuilder addAugmentation(Class<? extends Augmentation<NetconfCapabilityChange>> augmentationType, Augmentation<NetconfCapabilityChange> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public NetconfCapabilityChangeBuilder removeAugmentation(Class<? extends Augmentation<NetconfCapabilityChange>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NetconfCapabilityChange build() {
        return new NetconfCapabilityChangeImpl(this);
    }

    private static final class NetconfCapabilityChangeImpl
        extends AbstractAugmentable<NetconfCapabilityChange>
        implements NetconfCapabilityChange {
    
        private final List<Uri> _addedCapability;
        private final ChangedBy _changedBy;
        private final List<Uri> _deletedCapability;
        private final List<Uri> _modifiedCapability;
    
        NetconfCapabilityChangeImpl(NetconfCapabilityChangeBuilder base) {
            super(base.augmentation);
            this._addedCapability = base.getAddedCapability();
            this._changedBy = base.getChangedBy();
            this._deletedCapability = base.getDeletedCapability();
            this._modifiedCapability = base.getModifiedCapability();
        }
    
        @Override
        public List<Uri> getAddedCapability() {
            return _addedCapability;
        }
        
        @Override
        public ChangedBy getChangedBy() {
            return _changedBy;
        }
        
        @Override
        public List<Uri> getDeletedCapability() {
            return _deletedCapability;
        }
        
        @Override
        public List<Uri> getModifiedCapability() {
            return _modifiedCapability;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_addedCapability);
            result = prime * result + Objects.hashCode(_changedBy);
            result = prime * result + Objects.hashCode(_deletedCapability);
            result = prime * result + Objects.hashCode(_modifiedCapability);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NetconfCapabilityChange.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            NetconfCapabilityChange other = (NetconfCapabilityChange)obj;
            if (!Objects.equals(_addedCapability, other.getAddedCapability())) {
                return false;
            }
            if (!Objects.equals(_changedBy, other.getChangedBy())) {
                return false;
            }
            if (!Objects.equals(_deletedCapability, other.getDeletedCapability())) {
                return false;
            }
            if (!Objects.equals(_modifiedCapability, other.getModifiedCapability())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NetconfCapabilityChangeImpl otherImpl = (NetconfCapabilityChangeImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NetconfCapabilityChange>>, Augmentation<NetconfCapabilityChange>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NetconfCapabilityChange");
            CodeHelpers.appendValue(helper, "_addedCapability", _addedCapability);
            CodeHelpers.appendValue(helper, "_changedBy", _changedBy);
            CodeHelpers.appendValue(helper, "_deletedCapability", _deletedCapability);
            CodeHelpers.appendValue(helper, "_modifiedCapability", _modifiedCapability);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
