package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.changed.by.parms.ChangedBy;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.netconf.config.change.Edit;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NetconfConfigChangeBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     NetconfConfigChangeBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new NetconfConfigChangeBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of NetconfConfigChangeBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see NetconfConfigChangeBuilder
 * @see Builder
 *
 */
public class NetconfConfigChangeBuilder implements Builder<NetconfConfigChange> {

    private ChangedBy _changedBy;
    private NetconfConfigChange.Datastore _datastore;
    private List<Edit> _edit;


    Map<Class<? extends Augmentation<NetconfConfigChange>>, Augmentation<NetconfConfigChange>> augmentation = Collections.emptyMap();

    public NetconfConfigChangeBuilder() {
    }
    public NetconfConfigChangeBuilder(org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.ChangedByParms arg) {
        this._changedBy = arg.getChangedBy();
    }

    public NetconfConfigChangeBuilder(NetconfConfigChange base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<NetconfConfigChange>>, Augmentation<NetconfConfigChange>> aug =((AugmentationHolder<NetconfConfigChange>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._changedBy = base.getChangedBy();
        this._datastore = base.getDatastore();
        this._edit = base.getEdit();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.ChangedByParms</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.ChangedByParms) {
            this._changedBy = ((org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.ChangedByParms)arg).getChangedBy();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.ChangedByParms]");
    }

    public ChangedBy getChangedBy() {
        return _changedBy;
    }
    
    public NetconfConfigChange.Datastore getDatastore() {
        return _datastore;
    }
    
    public List<Edit> getEdit() {
        return _edit;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<NetconfConfigChange>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public NetconfConfigChangeBuilder setChangedBy(final ChangedBy value) {
        this._changedBy = value;
        return this;
    }
    
    public NetconfConfigChangeBuilder setDatastore(final NetconfConfigChange.Datastore value) {
        this._datastore = value;
        return this;
    }
    public NetconfConfigChangeBuilder setEdit(final List<Edit> values) {
        this._edit = values;
        return this;
    }
    
    
    public NetconfConfigChangeBuilder addAugmentation(Class<? extends Augmentation<NetconfConfigChange>> augmentationType, Augmentation<NetconfConfigChange> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public NetconfConfigChangeBuilder removeAugmentation(Class<? extends Augmentation<NetconfConfigChange>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NetconfConfigChange build() {
        return new NetconfConfigChangeImpl(this);
    }

    private static final class NetconfConfigChangeImpl
        extends AbstractAugmentable<NetconfConfigChange>
        implements NetconfConfigChange {
    
        private final ChangedBy _changedBy;
        private final NetconfConfigChange.Datastore _datastore;
        private final List<Edit> _edit;
    
        NetconfConfigChangeImpl(NetconfConfigChangeBuilder base) {
            super(base.augmentation);
            this._changedBy = base.getChangedBy();
            this._datastore = base.getDatastore();
            this._edit = base.getEdit();
        }
    
        @Override
        public ChangedBy getChangedBy() {
            return _changedBy;
        }
        
        @Override
        public NetconfConfigChange.Datastore getDatastore() {
            return _datastore;
        }
        
        @Override
        public List<Edit> getEdit() {
            return _edit;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_changedBy);
            result = prime * result + Objects.hashCode(_datastore);
            result = prime * result + Objects.hashCode(_edit);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NetconfConfigChange.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            NetconfConfigChange other = (NetconfConfigChange)obj;
            if (!Objects.equals(_changedBy, other.getChangedBy())) {
                return false;
            }
            if (!Objects.equals(_datastore, other.getDatastore())) {
                return false;
            }
            if (!Objects.equals(_edit, other.getEdit())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NetconfConfigChangeImpl otherImpl = (NetconfConfigChangeImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NetconfConfigChange>>, Augmentation<NetconfConfigChange>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NetconfConfigChange");
            CodeHelpers.appendValue(helper, "_changedBy", _changedBy);
            CodeHelpers.appendValue(helper, "_datastore", _datastore);
            CodeHelpers.appendValue(helper, "_edit", _edit);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
