package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMap.Builder;
import java.lang.Class;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Override;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Enumeration;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Generated when a NETCONF server detects that a confirmed-commit event has 
 * occurred. Indicates the event and the current state of the confirmed-commit 
 * procedure in progress.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>ietf-netconf-notifications</b>
 * <pre>
 * notification netconf-confirmed-commit {
 *   uses common-session-parms {
 *     when "confirm-event != 'timeout'";
 *   }
 *   leaf confirm-event {
 *     type enumeration {
 *       enum start {
 *       }
 *       enum cancel {
 *       }
 *       enum timeout {
 *       }
 *       enum extend {
 *       }
 *       enum complete {
 *       }
 *     }
 *   }
 *   leaf timeout {
 *     when "../confirm-event = 'start' or ../confirm-event = 'extend'";
 *     type uint32;
 *     units seconds;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>ietf-netconf-notifications/netconf-confirmed-commit</i>
 *
 * <p>To create instances of this class use {@link NetconfConfirmedCommitBuilder}.
 * @see NetconfConfirmedCommitBuilder
 *
 */
public interface NetconfConfirmedCommit
    extends
    DataObject,
    Augmentable<NetconfConfirmedCommit>,
    CommonSessionParms,
    Notification
{


    public enum ConfirmEvent implements Enumeration {
        /**
         * The confirmed-commit procedure has started.
         *
         */
        Start(0, "start"),
        
        /**
         * The confirmed-commit procedure has been canceled, e.g., due to the session being
         * terminated, or an explicit &amp;lt;cancel-commit&amp;gt; operation.
         *
         */
        Cancel(1, "cancel"),
        
        /**
         * The confirmed-commit procedure has been canceled due to the confirm-timeout 
         * interval expiring. The common session parameters will not be present in this 
         * sub-mode.
         *
         */
        Timeout(2, "timeout"),
        
        /**
         * The confirmed-commit timeout has been extended, e.g., by a new 
         * &amp;lt;confirmed-commit&amp;gt; operation.
         *
         */
        Extend(3, "extend"),
        
        /**
         * The confirmed-commit procedure has been completed.
         *
         */
        Complete(4, "complete")
        ;
    
        private static final Map<String, ConfirmEvent> NAME_MAP;
        private static final Map<Integer, ConfirmEvent> VALUE_MAP;
    
        static {
            final Builder<String, ConfirmEvent> nb = ImmutableMap.builder();
            final Builder<Integer, ConfirmEvent> vb = ImmutableMap.builder();
            for (ConfirmEvent enumItem : ConfirmEvent.values()) {
                vb.put(enumItem.value, enumItem);
                nb.put(enumItem.name, enumItem);
            }
    
            NAME_MAP = nb.build();
            VALUE_MAP = vb.build();
        }
    
        private final String name;
        private final int value;
    
        private ConfirmEvent(int value, String name) {
            this.value = value;
            this.name = name;
        }
    
        @Override
        public String getName() {
            return name;
        }
    
        @Override
        public int getIntValue() {
            return value;
        }
    
        /**
         * Return the enumeration member whose {@link #getName()} matches specified value.
         *
         * @param name YANG assigned name
         * @return corresponding ConfirmEvent item, if present
         * @throws NullPointerException if name is null
         */
        public static Optional<ConfirmEvent> forName(String name) {
            return Optional.ofNullable(NAME_MAP.get(Objects.requireNonNull(name)));
        }
    
        /**
         * Return the enumeration member whose {@link #getIntValue()} matches specified value.
         *
         * @param intValue integer value
         * @return corresponding ConfirmEvent item, or null if no such item exists
         */
        public static ConfirmEvent forValue(int intValue) {
            return VALUE_MAP.get(intValue);
        }
    }

    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("netconf-confirmed-commit");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.NetconfConfirmedCommit> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.NetconfConfirmedCommit.class;
    }
    
    /**
     * Indicates the event that caused the notification.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.NetconfConfirmedCommit.ConfirmEvent</code> <code>confirmEvent</code>, or <code>null</code> if not present
     */
    @Nullable ConfirmEvent getConfirmEvent();
    
    /**
     * The configured timeout value if the event type is 'start' or 'extend'. This 
     * value represents the approximate number of seconds from the event time when the 
     * 'timeout' event might occur.
     *
     *
     *
     * @return <code>java.lang.Long</code> <code>timeout</code>, or <code>null</code> if not present
     */
    @Nullable Long getTimeout();

}

