package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMap.Builder;
import java.lang.Class;
import java.lang.Integer;
import java.lang.Override;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.SessionIdType;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Enumeration;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Generated when a NETCONF server detects that a NETCONF session has terminated. 
 * server MAY optionally generate this event for non-NETCONF management sessions. 
 * Indicates the identity of the user that owned the session, and why the session 
 * was terminated.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>ietf-netconf-notifications</b>
 * <pre>
 * notification netconf-session-end {
 *   uses common-session-parms;
 *   leaf killed-by {
 *     when "../termination-reason = 'killed'";
 *     type nc:session-id-type;
 *   }
 *   leaf termination-reason {
 *     type enumeration {
 *       enum closed {
 *       }
 *       enum killed {
 *       }
 *       enum dropped {
 *       }
 *       enum timeout {
 *       }
 *       enum bad-hello {
 *       }
 *       enum other {
 *       }
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>ietf-netconf-notifications/netconf-session-end</i>
 *
 * <p>To create instances of this class use {@link NetconfSessionEndBuilder}.
 * @see NetconfSessionEndBuilder
 *
 */
public interface NetconfSessionEnd
    extends
    DataObject,
    Augmentable<NetconfSessionEnd>,
    CommonSessionParms,
    Notification
{


    public enum TerminationReason implements Enumeration {
        /**
         * The session was terminated by the client in normal fashion, e.g., by the NETCONF
         * &amp;lt;close-session&amp;gt; protocol operation.
         *
         */
        Closed(0, "closed"),
        
        /**
         * The session was terminated in abnormal fashion, e.g., by the NETCONF 
         * &amp;lt;kill-session&amp;gt; protocol operation.
         *
         */
        Killed(1, "killed"),
        
        /**
         * The session was terminated because the transport layer connection was 
         * unexpectedly closed.
         *
         */
        Dropped(2, "dropped"),
        
        /**
         * The session was terminated because of inactivity, e.g., waiting for the 
         * &amp;lt;hello&amp;gt; message or &amp;lt;rpc&amp;gt; messages.
         *
         */
        Timeout(3, "timeout"),
        
        /**
         * The client's &amp;lt;hello&amp;gt; message was invalid.
         *
         */
        BadHello(4, "bad-hello"),
        
        /**
         * The session was terminated for some other reason.
         *
         */
        Other(5, "other")
        ;
    
        private static final Map<String, TerminationReason> NAME_MAP;
        private static final Map<Integer, TerminationReason> VALUE_MAP;
    
        static {
            final Builder<String, TerminationReason> nb = ImmutableMap.builder();
            final Builder<Integer, TerminationReason> vb = ImmutableMap.builder();
            for (TerminationReason enumItem : TerminationReason.values()) {
                vb.put(enumItem.value, enumItem);
                nb.put(enumItem.name, enumItem);
            }
    
            NAME_MAP = nb.build();
            VALUE_MAP = vb.build();
        }
    
        private final String name;
        private final int value;
    
        private TerminationReason(int value, String name) {
            this.value = value;
            this.name = name;
        }
    
        @Override
        public String getName() {
            return name;
        }
    
        @Override
        public int getIntValue() {
            return value;
        }
    
        /**
         * Return the enumeration member whose {@link #getName()} matches specified value.
         *
         * @param name YANG assigned name
         * @return corresponding TerminationReason item, if present
         * @throws NullPointerException if name is null
         */
        public static Optional<TerminationReason> forName(String name) {
            return Optional.ofNullable(NAME_MAP.get(Objects.requireNonNull(name)));
        }
    
        /**
         * Return the enumeration member whose {@link #getIntValue()} matches specified value.
         *
         * @param intValue integer value
         * @return corresponding TerminationReason item, or null if no such item exists
         */
        public static TerminationReason forValue(int intValue) {
            return VALUE_MAP.get(intValue);
        }
    }

    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("netconf-session-end");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.NetconfSessionEnd> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.NetconfSessionEnd.class;
    }
    
    /**
     * The ID of the session that directly caused this session to be abnormally 
     * terminated. If this session was abnormally terminated by a non-NETCONF session 
     * unknown to the server, then this leaf will not be present.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.SessionIdType</code> <code>killedBy</code>, or <code>null</code> if not present
     */
    @Nullable SessionIdType getKilledBy();
    
    /**
     * Reason the session was terminated.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.NetconfSessionEnd.TerminationReason</code> <code>terminationReason</code>, or <code>null</code> if not present
     */
    @Nullable TerminationReason getTerminationReason();

}

