package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.SessionIdOrZeroType;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.SessionIdType;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NetconfSessionEndBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     NetconfSessionEndBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new NetconfSessionEndBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of NetconfSessionEndBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see NetconfSessionEndBuilder
 * @see Builder
 *
 */
public class NetconfSessionEndBuilder implements Builder<NetconfSessionEnd> {

    private SessionIdType _killedBy;
    private SessionIdOrZeroType _sessionId;
    private IpAddress _sourceHost;
    private NetconfSessionEnd.TerminationReason _terminationReason;
    private String _username;


    Map<Class<? extends Augmentation<NetconfSessionEnd>>, Augmentation<NetconfSessionEnd>> augmentation = Collections.emptyMap();

    public NetconfSessionEndBuilder() {
    }
    public NetconfSessionEndBuilder(org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.CommonSessionParms arg) {
        this._username = arg.getUsername();
        this._sessionId = arg.getSessionId();
        this._sourceHost = arg.getSourceHost();
    }

    public NetconfSessionEndBuilder(NetconfSessionEnd base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<NetconfSessionEnd>>, Augmentation<NetconfSessionEnd>> aug =((AugmentationHolder<NetconfSessionEnd>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._killedBy = base.getKilledBy();
        this._sessionId = base.getSessionId();
        this._sourceHost = base.getSourceHost();
        this._terminationReason = base.getTerminationReason();
        this._username = base.getUsername();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.CommonSessionParms</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.CommonSessionParms) {
            this._username = ((org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.CommonSessionParms)arg).getUsername();
            this._sessionId = ((org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.CommonSessionParms)arg).getSessionId();
            this._sourceHost = ((org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.CommonSessionParms)arg).getSourceHost();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.CommonSessionParms]");
    }

    public SessionIdType getKilledBy() {
        return _killedBy;
    }
    
    public SessionIdOrZeroType getSessionId() {
        return _sessionId;
    }
    
    public IpAddress getSourceHost() {
        return _sourceHost;
    }
    
    public NetconfSessionEnd.TerminationReason getTerminationReason() {
        return _terminationReason;
    }
    
    public String getUsername() {
        return _username;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<NetconfSessionEnd>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public NetconfSessionEndBuilder setKilledBy(final SessionIdType value) {
        this._killedBy = value;
        return this;
    }
    
    public NetconfSessionEndBuilder setSessionId(final SessionIdOrZeroType value) {
        this._sessionId = value;
        return this;
    }
    
    public NetconfSessionEndBuilder setSourceHost(final IpAddress value) {
        this._sourceHost = value;
        return this;
    }
    
    public NetconfSessionEndBuilder setTerminationReason(final NetconfSessionEnd.TerminationReason value) {
        this._terminationReason = value;
        return this;
    }
    
    public NetconfSessionEndBuilder setUsername(final String value) {
        this._username = value;
        return this;
    }
    
    public NetconfSessionEndBuilder addAugmentation(Class<? extends Augmentation<NetconfSessionEnd>> augmentationType, Augmentation<NetconfSessionEnd> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public NetconfSessionEndBuilder removeAugmentation(Class<? extends Augmentation<NetconfSessionEnd>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NetconfSessionEnd build() {
        return new NetconfSessionEndImpl(this);
    }

    private static final class NetconfSessionEndImpl
        extends AbstractAugmentable<NetconfSessionEnd>
        implements NetconfSessionEnd {
    
        private final SessionIdType _killedBy;
        private final SessionIdOrZeroType _sessionId;
        private final IpAddress _sourceHost;
        private final NetconfSessionEnd.TerminationReason _terminationReason;
        private final String _username;
    
        NetconfSessionEndImpl(NetconfSessionEndBuilder base) {
            super(base.augmentation);
            this._killedBy = base.getKilledBy();
            this._sessionId = base.getSessionId();
            this._sourceHost = base.getSourceHost();
            this._terminationReason = base.getTerminationReason();
            this._username = base.getUsername();
        }
    
        @Override
        public SessionIdType getKilledBy() {
            return _killedBy;
        }
        
        @Override
        public SessionIdOrZeroType getSessionId() {
            return _sessionId;
        }
        
        @Override
        public IpAddress getSourceHost() {
            return _sourceHost;
        }
        
        @Override
        public NetconfSessionEnd.TerminationReason getTerminationReason() {
            return _terminationReason;
        }
        
        @Override
        public String getUsername() {
            return _username;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_killedBy);
            result = prime * result + Objects.hashCode(_sessionId);
            result = prime * result + Objects.hashCode(_sourceHost);
            result = prime * result + Objects.hashCode(_terminationReason);
            result = prime * result + Objects.hashCode(_username);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NetconfSessionEnd.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            NetconfSessionEnd other = (NetconfSessionEnd)obj;
            if (!Objects.equals(_killedBy, other.getKilledBy())) {
                return false;
            }
            if (!Objects.equals(_sessionId, other.getSessionId())) {
                return false;
            }
            if (!Objects.equals(_sourceHost, other.getSourceHost())) {
                return false;
            }
            if (!Objects.equals(_terminationReason, other.getTerminationReason())) {
                return false;
            }
            if (!Objects.equals(_username, other.getUsername())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NetconfSessionEndImpl otherImpl = (NetconfSessionEndImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NetconfSessionEnd>>, Augmentation<NetconfSessionEnd>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NetconfSessionEnd");
            CodeHelpers.appendValue(helper, "_killedBy", _killedBy);
            CodeHelpers.appendValue(helper, "_sessionId", _sessionId);
            CodeHelpers.appendValue(helper, "_sourceHost", _sourceHost);
            CodeHelpers.appendValue(helper, "_terminationReason", _terminationReason);
            CodeHelpers.appendValue(helper, "_username", _username);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
