/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.Netconf;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.netconf.Streams;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NetconfBuilder
implements Builder<Netconf> {
    private Streams _streams;
    Map<Class<? extends Augmentation<Netconf>>, Augmentation<Netconf>> augmentation = Collections.emptyMap();

    public NetconfBuilder() {
    }

    public NetconfBuilder(Netconf base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Netconf>>, Augmentation<Netconf>>(aug);
        }
        this._streams = base.getStreams();
    }

    public Streams getStreams() {
        return this._streams;
    }

    public <E$$ extends Augmentation<Netconf>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public NetconfBuilder setStreams(Streams value) {
        this._streams = value;
        return this;
    }

    public NetconfBuilder addAugmentation(Class<? extends Augmentation<Netconf>> augmentationType, Augmentation<Netconf> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Netconf>>, Augmentation<Netconf>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public NetconfBuilder removeAugmentation(Class<? extends Augmentation<Netconf>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Netconf build() {
        return new NetconfImpl(this);
    }

    private static final class NetconfImpl
    extends AbstractAugmentable<Netconf>
    implements Netconf {
        private final Streams _streams;
        private int hash = 0;
        private volatile boolean hashValid = false;

        NetconfImpl(NetconfBuilder base) {
            super(base.augmentation);
            this._streams = base.getStreams();
        }

        @Override
        public Streams getStreams() {
            return this._streams;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._streams);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Netconf.class.equals((Object)((DataObject)obj).implementedInterface())) {
                return false;
            }
            Netconf other = (Netconf)obj;
            if (!Objects.equals(this._streams, other.getStreams())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                NetconfImpl otherImpl = (NetconfImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : this.augmentations().entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"Netconf");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_streams", (Object)this._streams);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", (Object)this.augmentations().values());
            return helper.toString();
        }
    }
}

