/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.SessionIdOrZeroType;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.CommonSessionParms;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.NetconfConfirmedCommit;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NetconfConfirmedCommitBuilder
implements Builder<NetconfConfirmedCommit> {
    private NetconfConfirmedCommit.ConfirmEvent _confirmEvent;
    private SessionIdOrZeroType _sessionId;
    private IpAddress _sourceHost;
    private Long _timeout;
    private String _username;
    Map<Class<? extends Augmentation<NetconfConfirmedCommit>>, Augmentation<NetconfConfirmedCommit>> augmentation = Collections.emptyMap();

    public NetconfConfirmedCommitBuilder() {
    }

    public NetconfConfirmedCommitBuilder(CommonSessionParms arg) {
        this._username = arg.getUsername();
        this._sessionId = arg.getSessionId();
        this._sourceHost = arg.getSourceHost();
    }

    public NetconfConfirmedCommitBuilder(NetconfConfirmedCommit base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NetconfConfirmedCommit>>, Augmentation<NetconfConfirmedCommit>>(aug);
        }
        this._confirmEvent = base.getConfirmEvent();
        this._sessionId = base.getSessionId();
        this._sourceHost = base.getSourceHost();
        this._timeout = base.getTimeout();
        this._username = base.getUsername();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof CommonSessionParms) {
            this._username = ((CommonSessionParms)arg).getUsername();
            this._sessionId = ((CommonSessionParms)arg).getSessionId();
            this._sourceHost = ((CommonSessionParms)arg).getSourceHost();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.CommonSessionParms]");
    }

    public NetconfConfirmedCommit.ConfirmEvent getConfirmEvent() {
        return this._confirmEvent;
    }

    public SessionIdOrZeroType getSessionId() {
        return this._sessionId;
    }

    public IpAddress getSourceHost() {
        return this._sourceHost;
    }

    public Long getTimeout() {
        return this._timeout;
    }

    public String getUsername() {
        return this._username;
    }

    public <E$$ extends Augmentation<NetconfConfirmedCommit>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public NetconfConfirmedCommitBuilder setConfirmEvent(NetconfConfirmedCommit.ConfirmEvent value) {
        this._confirmEvent = value;
        return this;
    }

    public NetconfConfirmedCommitBuilder setSessionId(SessionIdOrZeroType value) {
        this._sessionId = value;
        return this;
    }

    public NetconfConfirmedCommitBuilder setSourceHost(IpAddress value) {
        this._sourceHost = value;
        return this;
    }

    private static void checkTimeoutRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..4294967295]]", (long)value);
    }

    public NetconfConfirmedCommitBuilder setTimeout(Long value) {
        if (value != null) {
            NetconfConfirmedCommitBuilder.checkTimeoutRange(value);
        }
        this._timeout = value;
        return this;
    }

    public NetconfConfirmedCommitBuilder setUsername(String value) {
        this._username = value;
        return this;
    }

    public NetconfConfirmedCommitBuilder addAugmentation(Class<? extends Augmentation<NetconfConfirmedCommit>> augmentationType, Augmentation<NetconfConfirmedCommit> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NetconfConfirmedCommit>>, Augmentation<NetconfConfirmedCommit>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public NetconfConfirmedCommitBuilder removeAugmentation(Class<? extends Augmentation<NetconfConfirmedCommit>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public NetconfConfirmedCommit build() {
        return new NetconfConfirmedCommitImpl(this);
    }

    private static final class NetconfConfirmedCommitImpl
    extends AbstractAugmentable<NetconfConfirmedCommit>
    implements NetconfConfirmedCommit {
        private final NetconfConfirmedCommit.ConfirmEvent _confirmEvent;
        private final SessionIdOrZeroType _sessionId;
        private final IpAddress _sourceHost;
        private final Long _timeout;
        private final String _username;
        private int hash = 0;
        private volatile boolean hashValid = false;

        NetconfConfirmedCommitImpl(NetconfConfirmedCommitBuilder base) {
            super(base.augmentation);
            this._confirmEvent = base.getConfirmEvent();
            this._sessionId = base.getSessionId();
            this._sourceHost = base.getSourceHost();
            this._timeout = base.getTimeout();
            this._username = base.getUsername();
        }

        @Override
        public NetconfConfirmedCommit.ConfirmEvent getConfirmEvent() {
            return this._confirmEvent;
        }

        @Override
        public SessionIdOrZeroType getSessionId() {
            return this._sessionId;
        }

        @Override
        public IpAddress getSourceHost() {
            return this._sourceHost;
        }

        @Override
        public Long getTimeout() {
            return this._timeout;
        }

        @Override
        public String getUsername() {
            return this._username;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode((Object)this._confirmEvent);
            result = 31 * result + Objects.hashCode(this._sessionId);
            result = 31 * result + Objects.hashCode(this._sourceHost);
            result = 31 * result + Objects.hashCode(this._timeout);
            result = 31 * result + Objects.hashCode(this._username);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NetconfConfirmedCommit.class.equals((Object)((DataObject)obj).implementedInterface())) {
                return false;
            }
            NetconfConfirmedCommit other = (NetconfConfirmedCommit)obj;
            if (!Objects.equals((Object)this._confirmEvent, (Object)other.getConfirmEvent())) {
                return false;
            }
            if (!Objects.equals(this._sessionId, other.getSessionId())) {
                return false;
            }
            if (!Objects.equals(this._sourceHost, other.getSourceHost())) {
                return false;
            }
            if (!Objects.equals(this._timeout, other.getTimeout())) {
                return false;
            }
            if (!Objects.equals(this._username, other.getUsername())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                NetconfConfirmedCommitImpl otherImpl = (NetconfConfirmedCommitImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : this.augmentations().entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"NetconfConfirmedCommit");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_confirmEvent", (Object)((Object)this._confirmEvent));
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_sessionId", (Object)this._sessionId);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_sourceHost", (Object)this._sourceHost);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_timeout", (Object)this._timeout);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_username", (Object)this._username);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", (Object)this.augmentations().values());
            return helper.toString();
        }
    }
}

