/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.netconf.streams;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.notification._1._0.rev080714.StreamNameType;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.netconf.streams.Stream;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.netconf.streams.StreamKey;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.DateAndTime;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class StreamBuilder
implements Builder<Stream> {
    private String _description;
    private StreamNameType _name;
    private DateAndTime _replayLogCreationTime;
    private Boolean _replaySupport;
    private StreamKey key;
    Map<Class<? extends Augmentation<Stream>>, Augmentation<Stream>> augmentation = Collections.emptyMap();

    public StreamBuilder() {
    }

    public StreamBuilder(Stream base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Stream>>, Augmentation<Stream>>(aug);
        }
        this.key = base.key();
        this._name = base.getName();
        this._description = base.getDescription();
        this._replayLogCreationTime = base.getReplayLogCreationTime();
        this._replaySupport = base.getReplaySupport();
    }

    public StreamKey key() {
        return this.key;
    }

    public String getDescription() {
        return this._description;
    }

    public StreamNameType getName() {
        return this._name;
    }

    public DateAndTime getReplayLogCreationTime() {
        return this._replayLogCreationTime;
    }

    public Boolean getReplaySupport() {
        return this._replaySupport;
    }

    public <E$$ extends Augmentation<Stream>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public StreamBuilder withKey(StreamKey key) {
        this.key = key;
        return this;
    }

    public StreamBuilder setDescription(String value) {
        this._description = value;
        return this;
    }

    public StreamBuilder setName(StreamNameType value) {
        this._name = value;
        return this;
    }

    public StreamBuilder setReplayLogCreationTime(DateAndTime value) {
        this._replayLogCreationTime = value;
        return this;
    }

    public StreamBuilder setReplaySupport(Boolean value) {
        this._replaySupport = value;
        return this;
    }

    public StreamBuilder addAugmentation(Augmentation<Stream> augmentation) {
        Class augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Stream>>, Augmentation<Stream>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public StreamBuilder removeAugmentation(Class<? extends Augmentation<Stream>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Stream build() {
        return new StreamImpl(this);
    }

    private static final class StreamImpl
    extends AbstractAugmentable<Stream>
    implements Stream {
        private final String _description;
        private final StreamNameType _name;
        private final DateAndTime _replayLogCreationTime;
        private final Boolean _replaySupport;
        private final StreamKey key;
        private int hash = 0;
        private volatile boolean hashValid = false;

        StreamImpl(StreamBuilder base) {
            super(base.augmentation);
            this.key = base.key() != null ? base.key() : new StreamKey(base.getName());
            this._name = this.key.getName();
            this._description = base.getDescription();
            this._replayLogCreationTime = base.getReplayLogCreationTime();
            this._replaySupport = base.getReplaySupport();
        }

        @Override
        public StreamKey key() {
            return this.key;
        }

        @Override
        public String getDescription() {
            return this._description;
        }

        @Override
        public StreamNameType getName() {
            return this._name;
        }

        @Override
        public DateAndTime getReplayLogCreationTime() {
            return this._replayLogCreationTime;
        }

        @Override
        public Boolean getReplaySupport() {
            return this._replaySupport;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Stream.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Stream.bindingEquals(this, obj);
        }

        public String toString() {
            return Stream.bindingToString(this);
        }
    }
}

