/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.CommonSessionParms;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Enumeration;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint32;

public interface NetconfConfirmedCommit
extends DataObject,
Notification,
Augmentable<NetconfConfirmedCommit>,
CommonSessionParms {
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("netconf-confirmed-commit");

    default public Class<NetconfConfirmedCommit> implementedInterface() {
        return NetconfConfirmedCommit.class;
    }

    public static int bindingHashCode(@NonNull NetconfConfirmedCommit obj) {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hashCode((Object)obj.getConfirmEvent());
        result = 31 * result + Objects.hashCode(obj.getSessionId());
        result = 31 * result + Objects.hashCode(obj.getSourceHost());
        result = 31 * result + Objects.hashCode(obj.getTimeout());
        result = 31 * result + Objects.hashCode(obj.getUsername());
        for (Augmentation augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }

    public static boolean bindingEquals(@NonNull NetconfConfirmedCommit thisObj, Object obj) {
        if (thisObj == obj) {
            return true;
        }
        NetconfConfirmedCommit other = (NetconfConfirmedCommit)CodeHelpers.checkCast(NetconfConfirmedCommit.class, (Object)obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getSessionId(), other.getSessionId())) {
            return false;
        }
        if (!Objects.equals(thisObj.getTimeout(), other.getTimeout())) {
            return false;
        }
        if (!Objects.equals(thisObj.getUsername(), other.getUsername())) {
            return false;
        }
        if (!Objects.equals((Object)thisObj.getConfirmEvent(), (Object)other.getConfirmEvent())) {
            return false;
        }
        if (!Objects.equals(thisObj.getSourceHost(), other.getSourceHost())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }

    public static String bindingToString(@NonNull NetconfConfirmedCommit obj) {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"NetconfConfirmedCommit");
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"confirmEvent", (Object)((Object)obj.getConfirmEvent()));
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"sessionId", (Object)obj.getSessionId());
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"sourceHost", (Object)obj.getSourceHost());
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"timeout", (Object)obj.getTimeout());
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"username", (Object)obj.getUsername());
        CodeHelpers.appendAugmentations((MoreObjects.ToStringHelper)helper, (String)"augmentation", (Augmentable)obj);
        return helper.toString();
    }

    public ConfirmEvent getConfirmEvent();

    default public @NonNull ConfirmEvent requireConfirmEvent() {
        return (ConfirmEvent)((Object)CodeHelpers.require((Object)((Object)this.getConfirmEvent()), (String)"confirmevent"));
    }

    public Uint32 getTimeout();

    default public @NonNull Uint32 requireTimeout() {
        return (Uint32)CodeHelpers.require((Object)this.getTimeout(), (String)"timeout");
    }

    public static enum ConfirmEvent implements Enumeration
    {
        Start(0, "start"),
        Cancel(1, "cancel"),
        Timeout(2, "timeout"),
        Extend(3, "extend"),
        Complete(4, "complete");

        private static final Map<String, ConfirmEvent> NAME_MAP;
        private static final Map<Integer, ConfirmEvent> VALUE_MAP;
        private final String name;
        private final int value;

        private ConfirmEvent(int value, String name) {
            this.value = value;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public int getIntValue() {
            return this.value;
        }

        public static Optional<ConfirmEvent> forName(String name) {
            return Optional.ofNullable(NAME_MAP.get(Objects.requireNonNull(name)));
        }

        public static ConfirmEvent forValue(int intValue) {
            return VALUE_MAP.get(intValue);
        }

        static {
            ImmutableMap.Builder nb = ImmutableMap.builder();
            ImmutableMap.Builder vb = ImmutableMap.builder();
            for (ConfirmEvent enumItem : ConfirmEvent.values()) {
                vb.put((Object)enumItem.value, (Object)enumItem);
                nb.put((Object)enumItem.name, (Object)enumItem);
            }
            NAME_MAP = nb.build();
            VALUE_MAP = vb.build();
        }
    }
}

