/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.SessionIdType;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.CommonSessionParms;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Enumeration;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yangtools.yang.common.QName;

public interface NetconfSessionEnd
extends DataObject,
Notification,
Augmentable<NetconfSessionEnd>,
CommonSessionParms {
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("netconf-session-end");

    default public Class<NetconfSessionEnd> implementedInterface() {
        return NetconfSessionEnd.class;
    }

    public static int bindingHashCode(@NonNull NetconfSessionEnd obj) {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hashCode(obj.getKilledBy());
        result = 31 * result + Objects.hashCode(obj.getSessionId());
        result = 31 * result + Objects.hashCode(obj.getSourceHost());
        result = 31 * result + Objects.hashCode((Object)obj.getTerminationReason());
        result = 31 * result + Objects.hashCode(obj.getUsername());
        for (Augmentation augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }

    public static boolean bindingEquals(@NonNull NetconfSessionEnd thisObj, Object obj) {
        if (thisObj == obj) {
            return true;
        }
        NetconfSessionEnd other = (NetconfSessionEnd)CodeHelpers.checkCast(NetconfSessionEnd.class, (Object)obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getKilledBy(), other.getKilledBy())) {
            return false;
        }
        if (!Objects.equals(thisObj.getSessionId(), other.getSessionId())) {
            return false;
        }
        if (!Objects.equals(thisObj.getUsername(), other.getUsername())) {
            return false;
        }
        if (!Objects.equals(thisObj.getSourceHost(), other.getSourceHost())) {
            return false;
        }
        if (!Objects.equals((Object)thisObj.getTerminationReason(), (Object)other.getTerminationReason())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }

    public static String bindingToString(@NonNull NetconfSessionEnd obj) {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"NetconfSessionEnd");
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"killedBy", (Object)obj.getKilledBy());
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"sessionId", (Object)obj.getSessionId());
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"sourceHost", (Object)obj.getSourceHost());
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"terminationReason", (Object)((Object)obj.getTerminationReason()));
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"username", (Object)obj.getUsername());
        CodeHelpers.appendAugmentations((MoreObjects.ToStringHelper)helper, (String)"augmentation", (Augmentable)obj);
        return helper.toString();
    }

    public SessionIdType getKilledBy();

    default public @NonNull SessionIdType requireKilledBy() {
        return (SessionIdType)CodeHelpers.require((Object)this.getKilledBy(), (String)"killedby");
    }

    public TerminationReason getTerminationReason();

    default public @NonNull TerminationReason requireTerminationReason() {
        return (TerminationReason)((Object)CodeHelpers.require((Object)((Object)this.getTerminationReason()), (String)"terminationreason"));
    }

    public static enum TerminationReason implements Enumeration
    {
        Closed(0, "closed"),
        Killed(1, "killed"),
        Dropped(2, "dropped"),
        Timeout(3, "timeout"),
        BadHello(4, "bad-hello"),
        Other(5, "other");

        private static final Map<String, TerminationReason> NAME_MAP;
        private static final Map<Integer, TerminationReason> VALUE_MAP;
        private final String name;
        private final int value;

        private TerminationReason(int value, String name) {
            this.value = value;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public int getIntValue() {
            return this.value;
        }

        public static Optional<TerminationReason> forName(String name) {
            return Optional.ofNullable(NAME_MAP.get(Objects.requireNonNull(name)));
        }

        public static TerminationReason forValue(int intValue) {
            return VALUE_MAP.get(intValue);
        }

        static {
            ImmutableMap.Builder nb = ImmutableMap.builder();
            ImmutableMap.Builder vb = ImmutableMap.builder();
            for (TerminationReason enumItem : TerminationReason.values()) {
                vb.put((Object)enumItem.value, (Object)enumItem);
                nb.put((Object)enumItem.name, (Object)enumItem);
            }
            NAME_MAP = nb.build();
            VALUE_MAP = vb.build();
        }
    }
}

