/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.SessionIdOrZeroType;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.SessionIdType;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.CommonSessionParms;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.NetconfSessionEnd;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NetconfSessionEndBuilder
implements Builder<NetconfSessionEnd> {
    private SessionIdType _killedBy;
    private SessionIdOrZeroType _sessionId;
    private IpAddress _sourceHost;
    private NetconfSessionEnd.TerminationReason _terminationReason;
    private String _username;
    Map<Class<? extends Augmentation<NetconfSessionEnd>>, Augmentation<NetconfSessionEnd>> augmentation = Collections.emptyMap();

    public NetconfSessionEndBuilder() {
    }

    public NetconfSessionEndBuilder(CommonSessionParms arg) {
        this._username = arg.getUsername();
        this._sessionId = arg.getSessionId();
        this._sourceHost = arg.getSourceHost();
    }

    public NetconfSessionEndBuilder(NetconfSessionEnd base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NetconfSessionEnd>>, Augmentation<NetconfSessionEnd>>(aug);
        }
        this._killedBy = base.getKilledBy();
        this._sessionId = base.getSessionId();
        this._sourceHost = base.getSourceHost();
        this._terminationReason = base.getTerminationReason();
        this._username = base.getUsername();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof CommonSessionParms) {
            this._username = ((CommonSessionParms)arg).getUsername();
            this._sessionId = ((CommonSessionParms)arg).getSessionId();
            this._sourceHost = ((CommonSessionParms)arg).getSourceHost();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[CommonSessionParms]");
    }

    public SessionIdType getKilledBy() {
        return this._killedBy;
    }

    public SessionIdOrZeroType getSessionId() {
        return this._sessionId;
    }

    public IpAddress getSourceHost() {
        return this._sourceHost;
    }

    public NetconfSessionEnd.TerminationReason getTerminationReason() {
        return this._terminationReason;
    }

    public String getUsername() {
        return this._username;
    }

    public <E$$ extends Augmentation<NetconfSessionEnd>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public NetconfSessionEndBuilder setKilledBy(SessionIdType value) {
        this._killedBy = value;
        return this;
    }

    public NetconfSessionEndBuilder setSessionId(SessionIdOrZeroType value) {
        this._sessionId = value;
        return this;
    }

    public NetconfSessionEndBuilder setSourceHost(IpAddress value) {
        this._sourceHost = value;
        return this;
    }

    public NetconfSessionEndBuilder setTerminationReason(NetconfSessionEnd.TerminationReason value) {
        this._terminationReason = value;
        return this;
    }

    public NetconfSessionEndBuilder setUsername(String value) {
        this._username = value;
        return this;
    }

    public NetconfSessionEndBuilder addAugmentation(Augmentation<NetconfSessionEnd> augmentation) {
        Class augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NetconfSessionEnd>>, Augmentation<NetconfSessionEnd>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public NetconfSessionEndBuilder removeAugmentation(Class<? extends Augmentation<NetconfSessionEnd>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public NetconfSessionEnd build() {
        return new NetconfSessionEndImpl(this);
    }

    private static final class NetconfSessionEndImpl
    extends AbstractAugmentable<NetconfSessionEnd>
    implements NetconfSessionEnd {
        private final SessionIdType _killedBy;
        private final SessionIdOrZeroType _sessionId;
        private final IpAddress _sourceHost;
        private final NetconfSessionEnd.TerminationReason _terminationReason;
        private final String _username;
        private int hash = 0;
        private volatile boolean hashValid = false;

        NetconfSessionEndImpl(NetconfSessionEndBuilder base) {
            super(base.augmentation);
            this._killedBy = base.getKilledBy();
            this._sessionId = base.getSessionId();
            this._sourceHost = base.getSourceHost();
            this._terminationReason = base.getTerminationReason();
            this._username = base.getUsername();
        }

        @Override
        public SessionIdType getKilledBy() {
            return this._killedBy;
        }

        @Override
        public SessionIdOrZeroType getSessionId() {
            return this._sessionId;
        }

        @Override
        public IpAddress getSourceHost() {
            return this._sourceHost;
        }

        @Override
        public NetconfSessionEnd.TerminationReason getTerminationReason() {
            return this._terminationReason;
        }

        @Override
        public String getUsername() {
            return this._username;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = NetconfSessionEnd.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return NetconfSessionEnd.bindingEquals(this, obj);
        }

        public String toString() {
            return NetconfSessionEnd.bindingToString(this);
        }
    }
}

