/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.SessionIdOrZeroType;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.CommonSessionParms;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.NetconfSessionStart;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NetconfSessionStartBuilder
implements Builder<NetconfSessionStart> {
    private SessionIdOrZeroType _sessionId;
    private IpAddress _sourceHost;
    private String _username;
    Map<Class<? extends Augmentation<NetconfSessionStart>>, Augmentation<NetconfSessionStart>> augmentation = Collections.emptyMap();

    public NetconfSessionStartBuilder() {
    }

    public NetconfSessionStartBuilder(CommonSessionParms arg) {
        this._username = arg.getUsername();
        this._sessionId = arg.getSessionId();
        this._sourceHost = arg.getSourceHost();
    }

    public NetconfSessionStartBuilder(NetconfSessionStart base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NetconfSessionStart>>, Augmentation<NetconfSessionStart>>(aug);
        }
        this._sessionId = base.getSessionId();
        this._sourceHost = base.getSourceHost();
        this._username = base.getUsername();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof CommonSessionParms) {
            this._username = ((CommonSessionParms)arg).getUsername();
            this._sessionId = ((CommonSessionParms)arg).getSessionId();
            this._sourceHost = ((CommonSessionParms)arg).getSourceHost();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[CommonSessionParms]");
    }

    public SessionIdOrZeroType getSessionId() {
        return this._sessionId;
    }

    public IpAddress getSourceHost() {
        return this._sourceHost;
    }

    public String getUsername() {
        return this._username;
    }

    public <E$$ extends Augmentation<NetconfSessionStart>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public NetconfSessionStartBuilder setSessionId(SessionIdOrZeroType value) {
        this._sessionId = value;
        return this;
    }

    public NetconfSessionStartBuilder setSourceHost(IpAddress value) {
        this._sourceHost = value;
        return this;
    }

    public NetconfSessionStartBuilder setUsername(String value) {
        this._username = value;
        return this;
    }

    public NetconfSessionStartBuilder addAugmentation(Augmentation<NetconfSessionStart> augmentation) {
        Class augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NetconfSessionStart>>, Augmentation<NetconfSessionStart>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public NetconfSessionStartBuilder removeAugmentation(Class<? extends Augmentation<NetconfSessionStart>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public NetconfSessionStart build() {
        return new NetconfSessionStartImpl(this);
    }

    private static final class NetconfSessionStartImpl
    extends AbstractAugmentable<NetconfSessionStart>
    implements NetconfSessionStart {
        private final SessionIdOrZeroType _sessionId;
        private final IpAddress _sourceHost;
        private final String _username;
        private int hash = 0;
        private volatile boolean hashValid = false;

        NetconfSessionStartImpl(NetconfSessionStartBuilder base) {
            super(base.augmentation);
            this._sessionId = base.getSessionId();
            this._sourceHost = base.getSourceHost();
            this._username = base.getUsername();
        }

        @Override
        public SessionIdOrZeroType getSessionId() {
            return this._sessionId;
        }

        @Override
        public IpAddress getSourceHost() {
            return this._sourceHost;
        }

        @Override
        public String getUsername() {
            return this._username;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = NetconfSessionStart.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return NetconfSessionStart.bindingEquals(this, obj);
        }

        public String toString() {
            return NetconfSessionStart.bindingToString(this);
        }
    }
}

