package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.notification._1._0.rev080714;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.notification._1._0.rev080714.create.subscription.input.Filter;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.DateAndTime;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.RpcInput;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>notifications</b>
 * <pre>
 * input input {
 *   leaf stream {
 *     type streamNameType;
 *     default NETCONF;
 *   }
 *   anyxml filter {
 *   }
 *   leaf startTime {
 *     type yang:date-and-time;
 *   }
 *   leaf stopTime {
 *     type yang:date-and-time;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface CreateSubscriptionInput
    extends
    RpcInput,
    Augmentable<CreateSubscriptionInput>
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("input");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.notification._1._0.rev080714.CreateSubscriptionInput> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.notification._1._0.rev080714.CreateSubscriptionInput.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.notification._1._0.rev080714.@NonNull CreateSubscriptionInput obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getFilter());
        result = prime * result + Objects.hashCode(obj.getStartTime());
        result = prime * result + Objects.hashCode(obj.getStopTime());
        result = prime * result + Objects.hashCode(obj.getStream());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.notification._1._0.rev080714.@NonNull CreateSubscriptionInput thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.notification._1._0.rev080714.CreateSubscriptionInput other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.notification._1._0.rev080714.CreateSubscriptionInput.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getStartTime(), other.getStartTime())) {
            return false;
        }
        if (!Objects.equals(thisObj.getStopTime(), other.getStopTime())) {
            return false;
        }
        if (!Objects.equals(thisObj.getStream(), other.getStream())) {
            return false;
        }
        if (!Objects.equals(thisObj.getFilter(), other.getFilter())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.notification._1._0.rev080714.@NonNull CreateSubscriptionInput obj) {
        final var helper = MoreObjects.toStringHelper("CreateSubscriptionInput");
        CodeHelpers.appendValue(helper, "filter", obj.getFilter());
        CodeHelpers.appendValue(helper, "startTime", obj.getStartTime());
        CodeHelpers.appendValue(helper, "stopTime", obj.getStopTime());
        CodeHelpers.appendValue(helper, "stream", obj.getStream());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return stream, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         An optional parameter that indicates which stream of events is of interest. If
     *         not present, then events in the default NETCONF stream will be sent.
     *     </code>
     * </pre>
     *
     * @return {@code StreamNameType} stream, or {@code null} if it is not present.
     *
     */
    StreamNameType getStream();
    
    /**
     * Return stream, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         An optional parameter that indicates which stream of events is of interest. If
     *         not present, then events in the default NETCONF stream will be sent.
     *     </code>
     * </pre>
     *
     * @return {@code StreamNameType} stream, guaranteed to be non-null.
     * @throws NoSuchElementException if stream is not present
     *
     */
    default @NonNull StreamNameType requireStream() {
        return CodeHelpers.require(getStream(), "stream");
    }
    
    /**
     * Return filter, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         An optional parameter that indicates which subset of all possible events is of
     *         interest. The format of this parameter is the same as that of the filter
     *         parameter in the NETCONF protocol operations. If not present, all events not
     *         precluded by other parameters will be sent.
     *     </code>
     * </pre>
     *
     * @return {@code Filter} filter, or {@code null} if it is not present.
     *
     */
    Filter getFilter();
    
    /**
     * Return filter, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         An optional parameter that indicates which subset of all possible events is of
     *         interest. The format of this parameter is the same as that of the filter
     *         parameter in the NETCONF protocol operations. If not present, all events not
     *         precluded by other parameters will be sent.
     *     </code>
     * </pre>
     *
     * @return {@code Filter} filter, guaranteed to be non-null.
     * @throws NoSuchElementException if filter is not present
     *
     */
    default @NonNull Filter requireFilter() {
        return CodeHelpers.require(getFilter(), "filter");
    }
    
    /**
     * Return startTime, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         A parameter used to trigger the replay feature and indicates that the replay
     *         should start at the time specified. If start time is not present, this is not a
     *         replay subscription.
     *     </code>
     * </pre>
     *
     * @return {@code DateAndTime} startTime, or {@code null} if it is not present.
     *
     */
    DateAndTime getStartTime();
    
    /**
     * Return startTime, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         A parameter used to trigger the replay feature and indicates that the replay
     *         should start at the time specified. If start time is not present, this is not a
     *         replay subscription.
     *     </code>
     * </pre>
     *
     * @return {@code DateAndTime} startTime, guaranteed to be non-null.
     * @throws NoSuchElementException if startTime is not present
     *
     */
    default @NonNull DateAndTime requireStartTime() {
        return CodeHelpers.require(getStartTime(), "starttime");
    }
    
    /**
     * Return stopTime, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         An optional parameter used with the optional replay feature to indicate the
     *         newest notifications of interest. If stop time is not present, the notifications
     *         will continue until the subscription is terminated. Must be used with startTime.
     *     </code>
     * </pre>
     *
     * @return {@code DateAndTime} stopTime, or {@code null} if it is not present.
     *
     */
    DateAndTime getStopTime();
    
    /**
     * Return stopTime, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         An optional parameter used with the optional replay feature to indicate the
     *         newest notifications of interest. If stop time is not present, the notifications
     *         will continue until the subscription is terminated. Must be used with startTime.
     *     </code>
     * </pre>
     *
     * @return {@code DateAndTime} stopTime, guaranteed to be non-null.
     * @throws NoSuchElementException if stopTime is not present
     *
     */
    default @NonNull DateAndTime requireStopTime() {
        return CodeHelpers.require(getStopTime(), "stoptime");
    }

}

