package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.netconf;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.Netconf;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.netconf.streams.Stream;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.netconf.streams.StreamKey;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * The list of event streams supported by the system. When a query is issued, the 
 * returned set of streams is determined based on user privileges.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>nc-notifications</b>
 * <pre>
 * container streams {
 *   list stream {
 *     key name;
 *     min-elements 1;
 *     leaf name {
 *       type ncEvent:streamNameType;
 *     }
 *     leaf description {
 *       type string;
 *     }
 *     leaf replaySupport {
 *       type boolean;
 *     }
 *     leaf replayLogCreationTime {
 *       type yang:date-and-time;
 *     }
 *   }
 * }
 * </pre>
 * <p>To create instances of this class use {@link StreamsBuilder}.
 * @see StreamsBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface Streams
    extends
    ChildOf<Netconf>,
    Augmentable<Streams>
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("streams");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.netconf.Streams> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.netconf.Streams.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.netconf.@NonNull Streams obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getStream());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.netconf.@NonNull Streams thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.netconf.Streams other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.netconf.Streams.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getStream(), other.getStream())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.netconf.@NonNull Streams obj) {
        final var helper = MoreObjects.toStringHelper("Streams");
        CodeHelpers.appendValue(helper, "stream", obj.getStream());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return stream, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Stream name, description and other information.
     *     </code>
     * </pre>
     *
     * @return {@code Map<StreamKey, Stream>} stream, or {@code null} if it is not present.
     *
     */
    @Nullable Map<StreamKey, Stream> getStream();
    
    /**
     * Return stream, or an empty list if it is not present.
     *
     * @return {@code Map<StreamKey, Stream>} stream, or an empty list if it is not present.
     *
     */
    default @NonNull Map<StreamKey, Stream> nonnullStream() {
        return CodeHelpers.nonnull(getStream());
    }

}

