package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.netconf.streams;
import com.google.common.base.MoreObjects;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.notification._1._0.rev080714.StreamNameType;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.netconf.Streams;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.DateAndTime;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Stream name, description and other information.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>nc-notifications</b>
 * <pre>
 * list stream {
 *   key name;
 *   min-elements 1;
 *   leaf name {
 *     type ncEvent:streamNameType;
 *   }
 *   leaf description {
 *     type string;
 *   }
 *   leaf replaySupport {
 *     type boolean;
 *   }
 *   leaf replayLogCreationTime {
 *     type yang:date-and-time;
 *   }
 * }
 * </pre>
 * <p>To create instances of this class use {@link StreamBuilder}.
 * @see StreamBuilder
 * @see StreamKey
 *
 */
@Generated("mdsal-binding-generator")
public interface Stream
    extends
    ChildOf<Streams>,
    Augmentable<Stream>,
    Identifiable<StreamKey>
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("stream");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.netconf.streams.Stream> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.netconf.streams.Stream.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.netconf.streams.@NonNull Stream obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getDescription());
        result = prime * result + Objects.hashCode(obj.getName());
        result = prime * result + Objects.hashCode(obj.getReplayLogCreationTime());
        result = prime * result + Objects.hashCode(obj.getReplaySupport());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.netconf.streams.@NonNull Stream thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.netconf.streams.Stream other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.netconf.streams.Stream.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getReplaySupport(), other.getReplaySupport())) {
            return false;
        }
        if (!Objects.equals(thisObj.getDescription(), other.getDescription())) {
            return false;
        }
        if (!Objects.equals(thisObj.getName(), other.getName())) {
            return false;
        }
        if (!Objects.equals(thisObj.getReplayLogCreationTime(), other.getReplayLogCreationTime())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.netconf.streams.@NonNull Stream obj) {
        final var helper = MoreObjects.toStringHelper("Stream");
        CodeHelpers.appendValue(helper, "description", obj.getDescription());
        CodeHelpers.appendValue(helper, "name", obj.getName());
        CodeHelpers.appendValue(helper, "replayLogCreationTime", obj.getReplayLogCreationTime());
        CodeHelpers.appendValue(helper, "replaySupport", obj.getReplaySupport());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    @Override
    StreamKey key();
    
    /**
     * Return name, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The name of the event stream. If this is the default NETCONF stream, this must
     *         have the value 'NETCONF'.
     *     </code>
     * </pre>
     *
     * @return {@code StreamNameType} name, or {@code null} if it is not present.
     *
     */
    StreamNameType getName();
    
    /**
     * Return name, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The name of the event stream. If this is the default NETCONF stream, this must
     *         have the value 'NETCONF'.
     *     </code>
     * </pre>
     *
     * @return {@code StreamNameType} name, guaranteed to be non-null.
     * @throws NoSuchElementException if name is not present
     *
     */
    default @NonNull StreamNameType requireName() {
        return CodeHelpers.require(getName(), "name");
    }
    
    /**
     * Return description, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         A description of the event stream, including such information as the type of
     *         events that are sent over this stream.
     *     </code>
     * </pre>
     *
     * @return {@code String} description, or {@code null} if it is not present.
     *
     */
    String getDescription();
    
    /**
     * Return description, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         A description of the event stream, including such information as the type of
     *         events that are sent over this stream.
     *     </code>
     * </pre>
     *
     * @return {@code String} description, guaranteed to be non-null.
     * @throws NoSuchElementException if description is not present
     *
     */
    default @NonNull String requireDescription() {
        return CodeHelpers.require(getDescription(), "description");
    }
    
    /**
     * Return replaySupport, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         A description of the event stream, including such information as the type of
     *         events that are sent over this stream.
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} replaySupport, or {@code null} if it is not present.
     *
     */
    Boolean getReplaySupport();
    
    /**
     * Return replaySupport, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         A description of the event stream, including such information as the type of
     *         events that are sent over this stream.
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} replaySupport, guaranteed to be non-null.
     * @throws NoSuchElementException if replaySupport is not present
     *
     */
    default @NonNull Boolean requireReplaySupport() {
        return CodeHelpers.require(getReplaySupport(), "replaysupport");
    }
    
    /**
     * Return replayLogCreationTime, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The timestamp of the creation of the log used to support the replay function on
     *         this stream. Note that this might be earlier then the earliest available
     *         notification in the log. This object is updated if the log resets for some
     *         reason. This object MUST be present if replay is supported.
     *     </code>
     * </pre>
     *
     * @return {@code DateAndTime} replayLogCreationTime, or {@code null} if it is not present.
     *
     */
    DateAndTime getReplayLogCreationTime();
    
    /**
     * Return replayLogCreationTime, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The timestamp of the creation of the log used to support the replay function on
     *         this stream. Note that this might be earlier then the earliest available
     *         notification in the log. This object is updated if the log resets for some
     *         reason. This object MUST be present if replay is supported.
     *     </code>
     * </pre>
     *
     * @return {@code DateAndTime} replayLogCreationTime, guaranteed to be non-null.
     * @throws NoSuchElementException if replayLogCreationTime is not present
     *
     */
    default @NonNull DateAndTime requireReplayLogCreationTime() {
        return CodeHelpers.require(getReplayLogCreationTime(), "replaylogcreationtime");
    }

}

