package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.netconf.streams;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.notification._1._0.rev080714.StreamNameType;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.DateAndTime;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

/**
 * Class that builds {@link Stream} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Stream createStream(int fooXyzzy, int barBaz) {
 *         return new StreamBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Stream, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Stream
 *
 */
@Generated("mdsal-binding-generator")
public class StreamBuilder {

    private String _description;
    private StreamNameType _name;
    private DateAndTime _replayLogCreationTime;
    private Boolean _replaySupport;
    private StreamKey key;


    Map<Class<? extends Augmentation<Stream>>, Augmentation<Stream>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public StreamBuilder() {
        // No-op
    }

    
    

    /**
     * Construct a builder initialized with state from specified {@link Stream}.
     *
     * @param base Stream from which the builder should be initialized
     */
    public StreamBuilder(Stream base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this.key = base.key();
        this._name = base.getName();
        this._description = base.getDescription();
        this._replayLogCreationTime = base.getReplayLogCreationTime();
        this._replaySupport = base.getReplaySupport();
    }


    /**
     * Return current value associated with the property corresponding to {@link Stream#key()}.
     *
     * @return current value
     */
    public StreamKey key() {
        return key;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Stream#getDescription()}.
     *
     * @return current value
     */
    public String getDescription() {
        return _description;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Stream#getName()}.
     *
     * @return current value
     */
    public StreamNameType getName() {
        return _name;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Stream#getReplayLogCreationTime()}.
     *
     * @return current value
     */
    public DateAndTime getReplayLogCreationTime() {
        return _replayLogCreationTime;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Stream#getReplaySupport()}.
     *
     * @return current value
     */
    public Boolean getReplaySupport() {
        return _replaySupport;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Stream>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public StreamBuilder withKey(final StreamKey key) {
        this.key = key;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Stream#getDescription()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StreamBuilder setDescription(final String value) {
        this._description = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Stream#getName()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StreamBuilder setName(final StreamNameType value) {
        this._name = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Stream#getReplayLogCreationTime()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StreamBuilder setReplayLogCreationTime(final DateAndTime value) {
        this._replayLogCreationTime = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Stream#getReplaySupport()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StreamBuilder setReplaySupport(final Boolean value) {
        this._replaySupport = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public StreamBuilder addAugmentation(Augmentation<Stream> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public StreamBuilder removeAugmentation(Class<? extends Augmentation<Stream>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link Stream} instance.
     *
     * @return A new {@link Stream} instance.
     */
    public @NonNull Stream build() {
        return new StreamImpl(this);
    }

    private static final class StreamImpl
        extends AbstractAugmentable<Stream>
        implements Stream {
    
        private final String _description;
        private final StreamNameType _name;
        private final DateAndTime _replayLogCreationTime;
        private final Boolean _replaySupport;
        private final StreamKey key;
    
        StreamImpl(StreamBuilder base) {
            super(base.augmentation);
            if (base.key() != null) {
                this.key = base.key();
            } else {
                this.key = new StreamKey(base.getName());
            }
            this._name = key.getName();
            this._description = base.getDescription();
            this._replayLogCreationTime = base.getReplayLogCreationTime();
            this._replaySupport = base.getReplaySupport();
        }
    
        @Override
        public StreamKey key() {
            return key;
        }
        
        @Override
        public String getDescription() {
            return _description;
        }
        
        @Override
        public StreamNameType getName() {
            return _name;
        }
        
        @Override
        public DateAndTime getReplayLogCreationTime() {
            return _replayLogCreationTime;
        }
        
        @Override
        public Boolean getReplaySupport() {
            return _replaySupport;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Stream.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Stream.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Stream.bindingToString(this);
        }
    }
}
