package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206;
import java.lang.Class;
import java.lang.Override;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.changed.by.parms.ChangedBy;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Common parameters to identify the source of a change event, such as a 
 * configuration or capability change.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>ietf-netconf-notifications</b>
 * <pre>
 * grouping changed-by-parms {
 *   container changed-by {
 *     choice server-or-user {
 *       leaf server {
 *         type empty;
 *       }
 *       case by-user {
 *         uses common-session-parms;
 *       }
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface ChangedByParms
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("changed-by-parms");

    @Override
    Class<? extends ChangedByParms> implementedInterface();
    
    /**
     * Return changedBy, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Indicates the source of the change. If caused by internal action, then the empty
     *         leaf 'server' will be present. If caused by a management session, then the name,
     *         remote host address, and session ID of the session that made the change will be
     *         reported.
     *     </code>
     * </pre>
     *
     * @return {@code ChangedBy} changedBy, or {@code null} if it is not present.
     *
     */
    ChangedBy getChangedBy();

}

