package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.SessionIdOrZeroType;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Common session parameters to identify a management session.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>ietf-netconf-notifications</b>
 * <pre>
 * grouping common-session-parms {
 *   leaf username {
 *     type string;
 *   }
 *   leaf session-id {
 *     type nc:session-id-or-zero-type;
 *   }
 *   leaf source-host {
 *     type inet:ip-address;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface CommonSessionParms
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("common-session-parms");

    @Override
    Class<? extends CommonSessionParms> implementedInterface();
    
    /**
     * Return username, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Name of the user for the session.
     *     </code>
     * </pre>
     *
     * @return {@code String} username, or {@code null} if it is not present.
     *
     */
    String getUsername();
    
    /**
     * Return username, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Name of the user for the session.
     *     </code>
     * </pre>
     *
     * @return {@code String} username, guaranteed to be non-null.
     * @throws NoSuchElementException if username is not present
     *
     */
    default @NonNull String requireUsername() {
        return CodeHelpers.require(getUsername(), "username");
    }
    
    /**
     * Return sessionId, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Identifier of the session. A NETCONF session MUST be identified by a non-zero
     *         value. A non-NETCONF session MAY be identified by the value zero.
     *     </code>
     * </pre>
     *
     * @return {@code SessionIdOrZeroType} sessionId, or {@code null} if it is not present.
     *
     */
    SessionIdOrZeroType getSessionId();
    
    /**
     * Return sessionId, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Identifier of the session. A NETCONF session MUST be identified by a non-zero
     *         value. A non-NETCONF session MAY be identified by the value zero.
     *     </code>
     * </pre>
     *
     * @return {@code SessionIdOrZeroType} sessionId, guaranteed to be non-null.
     * @throws NoSuchElementException if sessionId is not present
     *
     */
    default @NonNull SessionIdOrZeroType requireSessionId() {
        return CodeHelpers.require(getSessionId(), "sessionid");
    }
    
    /**
     * Return sourceHost, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Address of the remote host for the session.
     *     </code>
     * </pre>
     *
     * @return {@code IpAddress} sourceHost, or {@code null} if it is not present.
     *
     */
    IpAddress getSourceHost();
    
    /**
     * Return sourceHost, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Address of the remote host for the session.
     *     </code>
     * </pre>
     *
     * @return {@code IpAddress} sourceHost, guaranteed to be non-null.
     * @throws NoSuchElementException if sourceHost is not present
     *
     */
    default @NonNull IpAddress requireSourceHost() {
        return CodeHelpers.require(getSourceHost(), "sourcehost");
    }

}

