package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206;
import javax.annotation.processing.Generated;
import org.opendaylight.yangtools.yang.binding.DataRoot;

/**
 * This module defines a YANG data model for use with the NETCONF protocol that 
 * allows the NETCONF client to receive common NETCONF base event notifications. 
 * Copyright (c) 2012 IETF Trust and the persons identified as the document 
 * authors. All rights reserved. Redistribution and use in source and binary 
 * with or without modification, is permitted pursuant to, and subject to the 
 * license terms contained in, the Simplified BSD License set forth in Section 4.c 
 * of the IETF Trust's Legal Provisions Relating to IETF Documents 
 * (http://trustee.ietf.org/license-info). This version of this YANG module is 
 * of RFC 6470; see the RFC itself for full legal notices.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>ietf-netconf-notifications</b>
 * <pre>
 * module ietf-netconf-notifications {
 *   namespace urn:ietf:params:xml:ns:yang:ietf-netconf-notifications;
 *   prefix ncn;
 *   import ietf-inet-types {
 *     prefix inet;
 *     revision-date 2013-07-15;
 *   }
 *   import ietf-netconf {
 *     prefix nc;
 *     revision-date 2011-06-01;
 *   }
 *   revision 2012-02-06 {
 *   }
 *   grouping common-session-parms {
 *     leaf username {
 *       type string;
 *     }
 *     leaf session-id {
 *       type nc:session-id-or-zero-type;
 *     }
 *     leaf source-host {
 *       type inet:ip-address;
 *     }
 *   }
 *   grouping changed-by-parms {
 *     container changed-by {
 *       choice server-or-user {
 *         leaf server {
 *           type empty;
 *         }
 *         case by-user {
 *           uses common-session-parms;
 *         }
 *       }
 *     }
 *   }
 *   notification netconf-config-change {
 *     uses changed-by-parms;
 *     leaf datastore {
 *       type enumeration {
 *         enum running {
 *         }
 *         enum startup {
 *         }
 *       }
 *       default running;
 *     }
 *     list edit {
 *       leaf target {
 *         type instance-identifier;
 *       }
 *       leaf operation {
 *         type nc:edit-operation-type;
 *       }
 *     }
 *   }
 *   notification netconf-capability-change {
 *     uses changed-by-parms;
 *     leaf-list added-capability {
 *       type inet:uri;
 *     }
 *     leaf-list deleted-capability {
 *       type inet:uri;
 *     }
 *     leaf-list modified-capability {
 *       type inet:uri;
 *     }
 *   }
 *   notification netconf-session-start {
 *     uses common-session-parms;
 *   }
 *   notification netconf-session-end {
 *     uses common-session-parms;
 *     leaf killed-by {
 *       when "../termination-reason = 'killed'";
 *       type nc:session-id-type;
 *     }
 *     leaf termination-reason {
 *       type enumeration {
 *         enum closed {
 *         }
 *         enum killed {
 *         }
 *         enum dropped {
 *         }
 *         enum timeout {
 *         }
 *         enum bad-hello {
 *         }
 *         enum other {
 *         }
 *       }
 *     }
 *   }
 *   notification netconf-confirmed-commit {
 *     uses common-session-parms {
 *       when "confirm-event != 'timeout'";
 *     }
 *     leaf confirm-event {
 *       type enumeration {
 *         enum start {
 *         }
 *         enum cancel {
 *         }
 *         enum timeout {
 *         }
 *         enum extend {
 *         }
 *         enum complete {
 *         }
 *       }
 *     }
 *     leaf timeout {
 *       when "../confirm-event = 'start' or ../confirm-event = 'extend'";
 *       type uint32;
 *       units seconds;
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface IetfNetconfNotificationsData
    extends
    DataRoot
{





}

