package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Uri;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Generated when the NETCONF server detects that the server capabilities have 
 * changed. Indicates which capabilities have been added, deleted, and/or 
 * The manner in which a server capability is changed is outside the scope of this 
 * document.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>ietf-netconf-notifications</b>
 * <pre>
 * notification netconf-capability-change {
 *   uses changed-by-parms;
 *   leaf-list added-capability {
 *     type inet:uri;
 *   }
 *   leaf-list deleted-capability {
 *     type inet:uri;
 *   }
 *   leaf-list modified-capability {
 *     type inet:uri;
 *   }
 * }
 * </pre>
 * <p>To create instances of this class use {@link NetconfCapabilityChangeBuilder}.
 * @see NetconfCapabilityChangeBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface NetconfCapabilityChange
    extends
    DataObject,
    Notification<NetconfCapabilityChange>,
    Augmentable<NetconfCapabilityChange>,
    ChangedByParms
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("netconf-capability-change");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.NetconfCapabilityChange> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.NetconfCapabilityChange.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.@NonNull NetconfCapabilityChange obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getAddedCapability());
        result = prime * result + Objects.hashCode(obj.getChangedBy());
        result = prime * result + Objects.hashCode(obj.getDeletedCapability());
        result = prime * result + Objects.hashCode(obj.getModifiedCapability());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.@NonNull NetconfCapabilityChange thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.NetconfCapabilityChange other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.NetconfCapabilityChange.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getAddedCapability(), other.getAddedCapability())) {
            return false;
        }
        if (!Objects.equals(thisObj.getChangedBy(), other.getChangedBy())) {
            return false;
        }
        if (!Objects.equals(thisObj.getDeletedCapability(), other.getDeletedCapability())) {
            return false;
        }
        if (!Objects.equals(thisObj.getModifiedCapability(), other.getModifiedCapability())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.@NonNull NetconfCapabilityChange obj) {
        final var helper = MoreObjects.toStringHelper("NetconfCapabilityChange");
        CodeHelpers.appendValue(helper, "addedCapability", obj.getAddedCapability());
        CodeHelpers.appendValue(helper, "changedBy", obj.getChangedBy());
        CodeHelpers.appendValue(helper, "deletedCapability", obj.getDeletedCapability());
        CodeHelpers.appendValue(helper, "modifiedCapability", obj.getModifiedCapability());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return addedCapability, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         List of capabilities that have just been added.
     *     </code>
     * </pre>
     *
     * @return {@code Set<Uri>} addedCapability, or {@code null} if it is not present.
     *
     */
    @Nullable Set<Uri> getAddedCapability();
    
    /**
     * Return addedCapability, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         List of capabilities that have just been added.
     *     </code>
     * </pre>
     *
     * @return {@code Set<Uri>} addedCapability, guaranteed to be non-null.
     * @throws NoSuchElementException if addedCapability is not present
     *
     */
    default @NonNull Set<Uri> requireAddedCapability() {
        return CodeHelpers.require(getAddedCapability(), "addedcapability");
    }
    
    /**
     * Return deletedCapability, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         List of capabilities that have just been deleted.
     *     </code>
     * </pre>
     *
     * @return {@code Set<Uri>} deletedCapability, or {@code null} if it is not present.
     *
     */
    @Nullable Set<Uri> getDeletedCapability();
    
    /**
     * Return deletedCapability, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         List of capabilities that have just been deleted.
     *     </code>
     * </pre>
     *
     * @return {@code Set<Uri>} deletedCapability, guaranteed to be non-null.
     * @throws NoSuchElementException if deletedCapability is not present
     *
     */
    default @NonNull Set<Uri> requireDeletedCapability() {
        return CodeHelpers.require(getDeletedCapability(), "deletedcapability");
    }
    
    /**
     * Return modifiedCapability, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         List of capabilities that have just been modified. A capability is considered to
     *         be modified if the base URI for the capability has not changed, but one or more
     *         of the parameters encoded at the end of the capability URI have changed. The new
     *         modified value of the complete URI is returned.
     *     </code>
     * </pre>
     *
     * @return {@code Set<Uri>} modifiedCapability, or {@code null} if it is not present.
     *
     */
    @Nullable Set<Uri> getModifiedCapability();
    
    /**
     * Return modifiedCapability, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         List of capabilities that have just been modified. A capability is considered to
     *         be modified if the base URI for the capability has not changed, but one or more
     *         of the parameters encoded at the end of the capability URI have changed. The new
     *         modified value of the complete URI is returned.
     *     </code>
     * </pre>
     *
     * @return {@code Set<Uri>} modifiedCapability, guaranteed to be non-null.
     * @throws NoSuchElementException if modifiedCapability is not present
     *
     */
    default @NonNull Set<Uri> requireModifiedCapability() {
        return CodeHelpers.require(getModifiedCapability(), "modifiedcapability");
    }

}

