package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMap.Builder;
import java.lang.Class;
import java.lang.Integer;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.netconf.config.change.Edit;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Enumeration;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Generated when the NETCONF server detects that the &lt;running&gt; or 
 * &lt;startup&gt; configuration datastore has been changed by a management 
 * session. The notification summarizes the edits that have been detected. The 
 * server MAY choose to also generate this notification while loading a datastore 
 * during the boot process for the device.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>ietf-netconf-notifications</b>
 * <pre>
 * notification netconf-config-change {
 *   uses changed-by-parms;
 *   leaf datastore {
 *     type enumeration {
 *       enum running {
 *       }
 *       enum startup {
 *       }
 *     }
 *     default running;
 *   }
 *   list edit {
 *     leaf target {
 *       type instance-identifier;
 *     }
 *     leaf operation {
 *       type nc:edit-operation-type;
 *     }
 *   }
 * }
 * </pre>
 * <p>To create instances of this class use {@link NetconfConfigChangeBuilder}.
 * @see NetconfConfigChangeBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface NetconfConfigChange
    extends
    DataObject,
    Notification<NetconfConfigChange>,
    Augmentable<NetconfConfigChange>,
    ChangedByParms
{


    @Generated("mdsal-binding-generator")
    public enum Datastore implements Enumeration {
        /**
         * The &amp;lt;running&amp;gt; datastore has changed.
         */
        Running(0, "running"),
        
        /**
         * The &amp;lt;startup&amp;gt; datastore has changed
         */
        Startup(1, "startup")
        ;
    
        private static final Map<String, Datastore> NAME_MAP;
        private static final Map<Integer, Datastore> VALUE_MAP;
    
        static {
            final Builder<String, Datastore> nb = ImmutableMap.builder();
            final Builder<Integer, Datastore> vb = ImmutableMap.builder();
            for (Datastore enumItem : Datastore.values()) {
                vb.put(enumItem.value, enumItem);
                nb.put(enumItem.name, enumItem);
            }
    
            NAME_MAP = nb.build();
            VALUE_MAP = vb.build();
        }
    
        private final String name;
        private final int value;
    
        private Datastore(int value, String name) {
            this.value = value;
            this.name = name;
        }
    
        @Override
        public String getName() {
            return name;
        }
    
        @Override
        public int getIntValue() {
            return value;
        }
    
        /**
         * Return the enumeration member whose {@link #getName()} matches specified value.
         *
         * @param name YANG assigned name
         * @return corresponding Datastore item, if present
         * @throws NullPointerException if {@code name} is null
         */
        public static Optional<Datastore> forName(String name) {
            return Optional.ofNullable(NAME_MAP.get(Objects.requireNonNull(name)));
        }
    
        /**
         * Return the enumeration member whose {@link #getIntValue()} matches specified value.
         *
         * @param intValue integer value
         * @return corresponding Datastore item, or null if no such item exists
         */
        public static Datastore forValue(int intValue) {
            return VALUE_MAP.get(intValue);
        }
    }

    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("netconf-config-change");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.NetconfConfigChange> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.NetconfConfigChange.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.@NonNull NetconfConfigChange obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getChangedBy());
        result = prime * result + Objects.hashCode(obj.getDatastore());
        result = prime * result + Objects.hashCode(obj.getEdit());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.@NonNull NetconfConfigChange thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.NetconfConfigChange other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.NetconfConfigChange.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getChangedBy(), other.getChangedBy())) {
            return false;
        }
        if (!Objects.equals(thisObj.getDatastore(), other.getDatastore())) {
            return false;
        }
        if (!Objects.equals(thisObj.getEdit(), other.getEdit())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.@NonNull NetconfConfigChange obj) {
        final var helper = MoreObjects.toStringHelper("NetconfConfigChange");
        CodeHelpers.appendValue(helper, "changedBy", obj.getChangedBy());
        CodeHelpers.appendValue(helper, "datastore", obj.getDatastore());
        CodeHelpers.appendValue(helper, "edit", obj.getEdit());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return datastore, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Indicates which configuration datastore has changed.
     *     </code>
     * </pre>
     *
     * @return {@code Datastore} datastore, or {@code null} if it is not present.
     *
     */
    Datastore getDatastore();
    
    /**
     * Return datastore, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Indicates which configuration datastore has changed.
     *     </code>
     * </pre>
     *
     * @return {@code Datastore} datastore, guaranteed to be non-null.
     * @throws NoSuchElementException if datastore is not present
     *
     */
    default @NonNull Datastore requireDatastore() {
        return CodeHelpers.require(getDatastore(), "datastore");
    }
    
    /**
     * Return edit, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         An edit record SHOULD be present for each distinct edit operation that the
     *         server has detected on the target datastore. This list MAY be omitted if the
     *         detailed edit operations are not known. The server MAY report entries in this
     *         list for changes not made by a NETCONF session (e.g., CLI).
     *     </code>
     * </pre>
     *
     * @return {@code List<Edit>} edit, or {@code null} if it is not present.
     *
     */
    @Nullable List<Edit> getEdit();
    
    /**
     * Return edit, or an empty list if it is not present.
     *
     * @return {@code List<Edit>} edit, or an empty list if it is not present.
     *
     */
    default @NonNull List<Edit> nonnullEdit() {
        return CodeHelpers.nonnull(getEdit());
    }

}

