package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.changed.by.parms.ChangedBy;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.netconf.config.change.Edit;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NetconfConfigChange} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     NetconfConfigChange createNetconfConfigChange(int fooXyzzy, int barBaz) {
 *         return new NetconfConfigChangeBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of NetconfConfigChange, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see NetconfConfigChange
 *
 */
@Generated("mdsal-binding-generator")
public class NetconfConfigChangeBuilder {

    private ChangedBy _changedBy;
    private NetconfConfigChange.Datastore _datastore;
    private List<Edit> _edit;


    Map<Class<? extends Augmentation<NetconfConfigChange>>, Augmentation<NetconfConfigChange>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public NetconfConfigChangeBuilder() {
        // No-op
    }

    
    
    
    /**
     * Construct a new builder initialized from specified {@link ChangedByParms}.
     *
     * @param arg ChangedByParms from which the builder should be initialized
     */
    public NetconfConfigChangeBuilder(ChangedByParms arg) {
        this._changedBy = arg.getChangedBy();
    }
    

    /**
     * Construct a builder initialized with state from specified {@link NetconfConfigChange}.
     *
     * @param base NetconfConfigChange from which the builder should be initialized
     */
    public NetconfConfigChangeBuilder(NetconfConfigChange base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._changedBy = base.getChangedBy();
        this._datastore = base.getDatastore();
        this._edit = base.getEdit();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link ChangedByParms}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ChangedByParms) {
            this._changedBy = ((ChangedByParms)arg).getChangedBy();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[ChangedByParms]");
    }

    /**
     * Return current value associated with the property corresponding to {@link NetconfConfigChange#getChangedBy()}.
     *
     * @return current value
     */
    public ChangedBy getChangedBy() {
        return _changedBy;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link NetconfConfigChange#getDatastore()}.
     *
     * @return current value
     */
    public NetconfConfigChange.Datastore getDatastore() {
        return _datastore;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link NetconfConfigChange#getEdit()}.
     *
     * @return current value
     */
    public List<Edit> getEdit() {
        return _edit;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<NetconfConfigChange>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link NetconfConfigChange#getChangedBy()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public NetconfConfigChangeBuilder setChangedBy(final ChangedBy value) {
        this._changedBy = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link NetconfConfigChange#getDatastore()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public NetconfConfigChangeBuilder setDatastore(final NetconfConfigChange.Datastore value) {
        this._datastore = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link NetconfConfigChange#getEdit()} to the specified
     * value.
     *
     * @param values desired value
     * @return this builder
     */
    public NetconfConfigChangeBuilder setEdit(final List<Edit> values) {
        this._edit = values;
        return this;
    }
    
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public NetconfConfigChangeBuilder addAugmentation(Augmentation<NetconfConfigChange> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public NetconfConfigChangeBuilder removeAugmentation(Class<? extends Augmentation<NetconfConfigChange>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link NetconfConfigChange} instance.
     *
     * @return A new {@link NetconfConfigChange} instance.
     */
    public @NonNull NetconfConfigChange build() {
        return new NetconfConfigChangeImpl(this);
    }

    private static final class NetconfConfigChangeImpl
        extends AbstractAugmentable<NetconfConfigChange>
        implements NetconfConfigChange {
    
        private final ChangedBy _changedBy;
        private final NetconfConfigChange.Datastore _datastore;
        private final List<Edit> _edit;
    
        NetconfConfigChangeImpl(NetconfConfigChangeBuilder base) {
            super(base.augmentation);
            this._changedBy = base.getChangedBy();
            this._datastore = base.getDatastore();
            this._edit = CodeHelpers.emptyToNull(base.getEdit());
        }
    
        @Override
        public ChangedBy getChangedBy() {
            return _changedBy;
        }
        
        @Override
        public NetconfConfigChange.Datastore getDatastore() {
            return _datastore;
        }
        
        @Override
        public List<Edit> getEdit() {
            return _edit;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = NetconfConfigChange.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return NetconfConfigChange.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return NetconfConfigChange.bindingToString(this);
        }
    }
}
