package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMap.Builder;
import java.lang.Class;
import java.lang.Integer;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Enumeration;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 * Generated when a NETCONF server detects that a confirmed-commit event has 
 * occurred. Indicates the event and the current state of the confirmed-commit 
 * procedure in progress.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>ietf-netconf-notifications</b>
 * <pre>
 * notification netconf-confirmed-commit {
 *   uses common-session-parms {
 *     when "confirm-event != 'timeout'";
 *   }
 *   leaf confirm-event {
 *     type enumeration {
 *       enum start {
 *       }
 *       enum cancel {
 *       }
 *       enum timeout {
 *       }
 *       enum extend {
 *       }
 *       enum complete {
 *       }
 *     }
 *   }
 *   leaf timeout {
 *     when "../confirm-event = 'start' or ../confirm-event = 'extend'";
 *     type uint32;
 *     units seconds;
 *   }
 * }
 * </pre>
 * <p>To create instances of this class use {@link NetconfConfirmedCommitBuilder}.
 * @see NetconfConfirmedCommitBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface NetconfConfirmedCommit
    extends
    DataObject,
    Notification<NetconfConfirmedCommit>,
    Augmentable<NetconfConfirmedCommit>,
    CommonSessionParms
{


    @Generated("mdsal-binding-generator")
    public enum ConfirmEvent implements Enumeration {
        /**
         * The confirmed-commit procedure has started.
         */
        Start(0, "start"),
        
        /**
         * The confirmed-commit procedure has been canceled,
         * e.g., due to the session being terminated, or an
         * explicit &amp;lt;cancel-commit&amp;gt; operation.
         */
        Cancel(1, "cancel"),
        
        /**
         * The confirmed-commit procedure has been canceled
         * due to the confirm-timeout interval expiring.
         * The common session parameters will not be present
         * in this sub-mode.
         */
        Timeout(2, "timeout"),
        
        /**
         * The confirmed-commit timeout has been extended,
         * e.g., by a new &amp;lt;confirmed-commit&amp;gt; operation.
         */
        Extend(3, "extend"),
        
        /**
         * The confirmed-commit procedure has been completed.
         */
        Complete(4, "complete")
        ;
    
        private static final Map<String, ConfirmEvent> NAME_MAP;
        private static final Map<Integer, ConfirmEvent> VALUE_MAP;
    
        static {
            final Builder<String, ConfirmEvent> nb = ImmutableMap.builder();
            final Builder<Integer, ConfirmEvent> vb = ImmutableMap.builder();
            for (ConfirmEvent enumItem : ConfirmEvent.values()) {
                vb.put(enumItem.value, enumItem);
                nb.put(enumItem.name, enumItem);
            }
    
            NAME_MAP = nb.build();
            VALUE_MAP = vb.build();
        }
    
        private final String name;
        private final int value;
    
        private ConfirmEvent(int value, String name) {
            this.value = value;
            this.name = name;
        }
    
        @Override
        public String getName() {
            return name;
        }
    
        @Override
        public int getIntValue() {
            return value;
        }
    
        /**
         * Return the enumeration member whose {@link #getName()} matches specified value.
         *
         * @param name YANG assigned name
         * @return corresponding ConfirmEvent item, if present
         * @throws NullPointerException if {@code name} is null
         */
        public static Optional<ConfirmEvent> forName(String name) {
            return Optional.ofNullable(NAME_MAP.get(Objects.requireNonNull(name)));
        }
    
        /**
         * Return the enumeration member whose {@link #getIntValue()} matches specified value.
         *
         * @param intValue integer value
         * @return corresponding ConfirmEvent item, or null if no such item exists
         */
        public static ConfirmEvent forValue(int intValue) {
            return VALUE_MAP.get(intValue);
        }
    }

    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("netconf-confirmed-commit");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.NetconfConfirmedCommit> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.NetconfConfirmedCommit.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.@NonNull NetconfConfirmedCommit obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getConfirmEvent());
        result = prime * result + Objects.hashCode(obj.getSessionId());
        result = prime * result + Objects.hashCode(obj.getSourceHost());
        result = prime * result + Objects.hashCode(obj.getTimeout());
        result = prime * result + Objects.hashCode(obj.getUsername());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.@NonNull NetconfConfirmedCommit thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.NetconfConfirmedCommit other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.NetconfConfirmedCommit.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getSessionId(), other.getSessionId())) {
            return false;
        }
        if (!Objects.equals(thisObj.getTimeout(), other.getTimeout())) {
            return false;
        }
        if (!Objects.equals(thisObj.getUsername(), other.getUsername())) {
            return false;
        }
        if (!Objects.equals(thisObj.getConfirmEvent(), other.getConfirmEvent())) {
            return false;
        }
        if (!Objects.equals(thisObj.getSourceHost(), other.getSourceHost())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.@NonNull NetconfConfirmedCommit obj) {
        final var helper = MoreObjects.toStringHelper("NetconfConfirmedCommit");
        CodeHelpers.appendValue(helper, "confirmEvent", obj.getConfirmEvent());
        CodeHelpers.appendValue(helper, "sessionId", obj.getSessionId());
        CodeHelpers.appendValue(helper, "sourceHost", obj.getSourceHost());
        CodeHelpers.appendValue(helper, "timeout", obj.getTimeout());
        CodeHelpers.appendValue(helper, "username", obj.getUsername());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return confirmEvent, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Indicates the event that caused the notification.
     *     </code>
     * </pre>
     *
     * @return {@code ConfirmEvent} confirmEvent, or {@code null} if it is not present.
     *
     */
    ConfirmEvent getConfirmEvent();
    
    /**
     * Return confirmEvent, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Indicates the event that caused the notification.
     *     </code>
     * </pre>
     *
     * @return {@code ConfirmEvent} confirmEvent, guaranteed to be non-null.
     * @throws NoSuchElementException if confirmEvent is not present
     *
     */
    default @NonNull ConfirmEvent requireConfirmEvent() {
        return CodeHelpers.require(getConfirmEvent(), "confirmevent");
    }
    
    /**
     * Return timeout, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The configured timeout value if the event type is 'start' or 'extend'. This
     *         value represents the approximate number of seconds from the event time when the
     *         'timeout' event might occur.
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} timeout, or {@code null} if it is not present.
     *
     */
    Uint32 getTimeout();
    
    /**
     * Return timeout, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The configured timeout value if the event type is 'start' or 'extend'. This
     *         value represents the approximate number of seconds from the event time when the
     *         'timeout' event might occur.
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} timeout, guaranteed to be non-null.
     * @throws NoSuchElementException if timeout is not present
     *
     */
    default @NonNull Uint32 requireTimeout() {
        return CodeHelpers.require(getTimeout(), "timeout");
    }

}

