package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMap.Builder;
import java.lang.Class;
import java.lang.Integer;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.SessionIdType;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Enumeration;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Generated when a NETCONF server detects that a NETCONF session has terminated. 
 * server MAY optionally generate this event for non-NETCONF management sessions. 
 * Indicates the identity of the user that owned the session, and why the session 
 * was terminated.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>ietf-netconf-notifications</b>
 * <pre>
 * notification netconf-session-end {
 *   uses common-session-parms;
 *   leaf killed-by {
 *     when "../termination-reason = 'killed'";
 *     type nc:session-id-type;
 *   }
 *   leaf termination-reason {
 *     type enumeration {
 *       enum closed {
 *       }
 *       enum killed {
 *       }
 *       enum dropped {
 *       }
 *       enum timeout {
 *       }
 *       enum bad-hello {
 *       }
 *       enum other {
 *       }
 *     }
 *   }
 * }
 * </pre>
 * <p>To create instances of this class use {@link NetconfSessionEndBuilder}.
 * @see NetconfSessionEndBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface NetconfSessionEnd
    extends
    DataObject,
    Notification<NetconfSessionEnd>,
    Augmentable<NetconfSessionEnd>,
    CommonSessionParms
{


    @Generated("mdsal-binding-generator")
    public enum TerminationReason implements Enumeration {
        /**
         * The session was terminated by the client in normal
         * fashion, e.g., by the NETCONF &amp;lt;close-session&amp;gt;
         * protocol operation.
         */
        Closed(0, "closed"),
        
        /**
         * The session was terminated in abnormal
         * fashion, e.g., by the NETCONF &amp;lt;kill-session&amp;gt;
         * protocol operation.
         */
        Killed(1, "killed"),
        
        /**
         * The session was terminated because the transport layer
         * connection was unexpectedly closed.
         */
        Dropped(2, "dropped"),
        
        /**
         * The session was terminated because of inactivity,
         * e.g., waiting for the &amp;lt;hello&amp;gt; message or &amp;lt;rpc&amp;gt;
         * messages.
         */
        Timeout(3, "timeout"),
        
        /**
         * The client's &amp;lt;hello&amp;gt; message was invalid.
         */
        BadHello(4, "bad-hello"),
        
        /**
         * The session was terminated for some other reason.
         */
        Other(5, "other")
        ;
    
        private static final Map<String, TerminationReason> NAME_MAP;
        private static final Map<Integer, TerminationReason> VALUE_MAP;
    
        static {
            final Builder<String, TerminationReason> nb = ImmutableMap.builder();
            final Builder<Integer, TerminationReason> vb = ImmutableMap.builder();
            for (TerminationReason enumItem : TerminationReason.values()) {
                vb.put(enumItem.value, enumItem);
                nb.put(enumItem.name, enumItem);
            }
    
            NAME_MAP = nb.build();
            VALUE_MAP = vb.build();
        }
    
        private final String name;
        private final int value;
    
        private TerminationReason(int value, String name) {
            this.value = value;
            this.name = name;
        }
    
        @Override
        public String getName() {
            return name;
        }
    
        @Override
        public int getIntValue() {
            return value;
        }
    
        /**
         * Return the enumeration member whose {@link #getName()} matches specified value.
         *
         * @param name YANG assigned name
         * @return corresponding TerminationReason item, if present
         * @throws NullPointerException if {@code name} is null
         */
        public static Optional<TerminationReason> forName(String name) {
            return Optional.ofNullable(NAME_MAP.get(Objects.requireNonNull(name)));
        }
    
        /**
         * Return the enumeration member whose {@link #getIntValue()} matches specified value.
         *
         * @param intValue integer value
         * @return corresponding TerminationReason item, or null if no such item exists
         */
        public static TerminationReason forValue(int intValue) {
            return VALUE_MAP.get(intValue);
        }
    }

    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("netconf-session-end");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.NetconfSessionEnd> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.NetconfSessionEnd.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.@NonNull NetconfSessionEnd obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getKilledBy());
        result = prime * result + Objects.hashCode(obj.getSessionId());
        result = prime * result + Objects.hashCode(obj.getSourceHost());
        result = prime * result + Objects.hashCode(obj.getTerminationReason());
        result = prime * result + Objects.hashCode(obj.getUsername());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.@NonNull NetconfSessionEnd thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.NetconfSessionEnd other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.NetconfSessionEnd.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getKilledBy(), other.getKilledBy())) {
            return false;
        }
        if (!Objects.equals(thisObj.getSessionId(), other.getSessionId())) {
            return false;
        }
        if (!Objects.equals(thisObj.getUsername(), other.getUsername())) {
            return false;
        }
        if (!Objects.equals(thisObj.getSourceHost(), other.getSourceHost())) {
            return false;
        }
        if (!Objects.equals(thisObj.getTerminationReason(), other.getTerminationReason())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.@NonNull NetconfSessionEnd obj) {
        final var helper = MoreObjects.toStringHelper("NetconfSessionEnd");
        CodeHelpers.appendValue(helper, "killedBy", obj.getKilledBy());
        CodeHelpers.appendValue(helper, "sessionId", obj.getSessionId());
        CodeHelpers.appendValue(helper, "sourceHost", obj.getSourceHost());
        CodeHelpers.appendValue(helper, "terminationReason", obj.getTerminationReason());
        CodeHelpers.appendValue(helper, "username", obj.getUsername());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return killedBy, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The ID of the session that directly caused this session to be abnormally
     *         terminated. If this session was abnormally terminated by a non-NETCONF session
     *         unknown to the server, then this leaf will not be present.
     *     </code>
     * </pre>
     *
     * @return {@code SessionIdType} killedBy, or {@code null} if it is not present.
     *
     */
    SessionIdType getKilledBy();
    
    /**
     * Return killedBy, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The ID of the session that directly caused this session to be abnormally
     *         terminated. If this session was abnormally terminated by a non-NETCONF session
     *         unknown to the server, then this leaf will not be present.
     *     </code>
     * </pre>
     *
     * @return {@code SessionIdType} killedBy, guaranteed to be non-null.
     * @throws NoSuchElementException if killedBy is not present
     *
     */
    default @NonNull SessionIdType requireKilledBy() {
        return CodeHelpers.require(getKilledBy(), "killedby");
    }
    
    /**
     * Return terminationReason, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Reason the session was terminated.
     *     </code>
     * </pre>
     *
     * @return {@code TerminationReason} terminationReason, or {@code null} if it is not present.
     *
     */
    TerminationReason getTerminationReason();
    
    /**
     * Return terminationReason, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Reason the session was terminated.
     *     </code>
     * </pre>
     *
     * @return {@code TerminationReason} terminationReason, guaranteed to be non-null.
     * @throws NoSuchElementException if terminationReason is not present
     *
     */
    default @NonNull TerminationReason requireTerminationReason() {
        return CodeHelpers.require(getTerminationReason(), "terminationreason");
    }

}

